/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.validation.model.ConstraintSeverity;

public class ConstraintSeverityTest
extends TestCase {
    public void test_getInstance() {
        ConstraintSeverityTest.assertSame((Object)ConstraintSeverity.NULL, (Object)ConstraintSeverity.getInstance((String)""));
        ConstraintSeverityTest.assertSame((Object)ConstraintSeverity.INFO, (Object)ConstraintSeverity.getInstance((String)ConstraintSeverity.INFO.getName()));
        ConstraintSeverityTest.assertSame((Object)ConstraintSeverity.WARNING, (Object)ConstraintSeverity.getInstance((String)ConstraintSeverity.WARNING.getName()));
        ConstraintSeverityTest.assertSame((Object)ConstraintSeverity.ERROR, (Object)ConstraintSeverity.getInstance((String)ConstraintSeverity.ERROR.getName()));
    }

    public void test_getAllInstances() {
        List instances = ConstraintSeverity.getAllInstances();
        ConstraintSeverityTest.assertTrue((boolean)instances.contains(ConstraintSeverity.NULL));
        ConstraintSeverityTest.assertTrue((boolean)instances.contains(ConstraintSeverity.INFO));
        ConstraintSeverityTest.assertTrue((boolean)instances.contains(ConstraintSeverity.WARNING));
        ConstraintSeverityTest.assertTrue((boolean)instances.contains(ConstraintSeverity.ERROR));
    }

    public void test_getName() {
        ConstraintSeverityTest.assertEquals((String)"none", (String)ConstraintSeverity.NULL.getName());
        ConstraintSeverityTest.assertEquals((String)"INFO", (String)ConstraintSeverity.INFO.getName());
        ConstraintSeverityTest.assertEquals((String)"WARNING", (String)ConstraintSeverity.WARNING.getName());
        ConstraintSeverityTest.assertEquals((String)"ERROR", (String)ConstraintSeverity.ERROR.getName());
    }

    public void test_isNull() {
        ConstraintSeverityTest.assertTrue((boolean)ConstraintSeverity.NULL.isNull());
        ConstraintSeverityTest.assertFalse((boolean)ConstraintSeverity.INFO.isNull());
        ConstraintSeverityTest.assertFalse((boolean)ConstraintSeverity.WARNING.isNull());
        ConstraintSeverityTest.assertFalse((boolean)ConstraintSeverity.ERROR.isNull());
    }

    public void test_readResolve() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutput output = null;
        ObjectInput input = null;
        try {
            try {
                output = new ObjectOutputStream(stream);
                for (ConstraintSeverity next : ConstraintSeverity.getAllInstances()) {
                    output.writeObject(next);
                }
                output.flush();
                input = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                for (ConstraintSeverity next : ConstraintSeverity.getAllInstances()) {
                    ConstraintSeverityTest.assertSame((Object)next, (Object)input.readObject());
                }
            }
            catch (Exception e) {
                ConstraintSeverityTest.fail((String)e.getLocalizedMessage());
                try {
                    output.close();
                    input.close();
                }
                catch (Exception e2) {
                    ConstraintSeverityTest.fail((String)e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                output.close();
                input.close();
            }
            catch (Exception e) {
                ConstraintSeverityTest.fail((String)e.getLocalizedMessage());
            }
        }
    }
}

