/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import ordersystem.OrderSystemFactory;
import ordersystem.Product;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.service.GetBatchConstraintsOperation;
import org.eclipse.emf.validation.internal.service.GetLiveConstraintsOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.ProviderDescriptor;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.tests.TestNotification;
import org.eclipse.emf.validation.xml.XmlConstraintProvider;

public class ProviderDescriptorTest
extends TestBase {
    private ConstraintDescriptorTest.FixtureElement config;
    private ProviderDescriptor fixture;

    public ProviderDescriptorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.config = ConstraintDescriptorTest.FixtureElement.build("constraintProvider", new String[][]{{"class", XmlConstraintProvider.class.getName()}, {"cache", "false"}});
        this.config.addChild(ConstraintDescriptorTest.FixtureElement.build("package", new String[][]{{"namespaceUri", "http:///ordersystem.ecore"}}));
    }

    private ConstraintDescriptorTest.FixtureElement getConfig() {
        return this.config;
    }

    private ProviderDescriptor getFixture() {
        if (this.fixture == null) {
            try {
                this.fixture = new ProviderDescriptor((IConfigurationElement)this.getConfig());
            }
            catch (CoreException e) {
                ProviderDescriptorTest.fail((String)("Exception on initializing fixture: " + e.getLocalizedMessage()));
            }
        }
        return this.fixture;
    }

    public void test_provides_batch() {
        this.getConfig().putAttribute("mode", "Batch").addChild(ConstraintDescriptorTest.FixtureElement.build("target", new String[][]{{"class", "Product"}}));
        class TestOp
        extends GetBatchConstraintsOperation {
            TestOp(EObject target) {
                super(true);
                this.setTarget(target);
            }
        }
        TestOp op = new TestOp(OrderSystemFactory.eINSTANCE.createProduct());
        ProviderDescriptorTest.assertTrue((String)"Batch operation not provided", (boolean)this.getFixture().provides((IProviderOperation)op));
        op = new TestOp(OrderSystemFactory.eINSTANCE.createWarehouse());
        ProviderDescriptorTest.assertFalse((String)"Batch operation is provided", (boolean)this.getFixture().provides((IProviderOperation)op));
    }

    public void test_provides_live() {
        this.getConfig().putAttribute("mode", "Live").addChild(ConstraintDescriptorTest.FixtureElement.build("target", new String[][]{{"class", "Product"}}).addChild(ConstraintDescriptorTest.FixtureElement.build("event", new String[][]{{"name", "Remove"}})));
        Product target = OrderSystemFactory.eINSTANCE.createProduct();
        class TestOp
        extends GetLiveConstraintsOperation {
            TestOp(Notification notification) {
                this.setNotification(notification);
            }
        }
        TestOp op = new TestOp((Notification)new TestNotification(target, 4));
        ProviderDescriptorTest.assertTrue((String)"Live operation not provided", (boolean)this.getFixture().provides((IProviderOperation)op));
        op = new TestOp((Notification)new TestNotification(target, 3));
        ProviderDescriptorTest.assertFalse((String)"Live operation is provided", (boolean)this.getFixture().provides((IProviderOperation)op));
    }

    public void test_isCacheEnabled() {
        ProviderDescriptorTest.assertFalse((String)"Cache should not be enabled", (boolean)this.getFixture().isCacheEnabled());
    }

    public void test_isCache() {
        ProviderDescriptorTest.assertFalse((String)"Should not be a cache", (boolean)this.getFixture().isCache());
    }

    public void test_isXmlProvider() {
        ProviderDescriptorTest.assertTrue((String)"Should be an XML provider", (boolean)this.getFixture().isXmlProvider());
    }

    public void test_getProvider() {
        IModelConstraintProvider provider = this.getFixture().getProvider();
        ProviderDescriptorTest.assertNotNull((String)"Provider is null", (Object)provider);
        ProviderDescriptorTest.assertSame((String)"Provider initialized twice", (Object)provider, (Object)this.getFixture().getProvider());
    }

    public void test_concurrentInitialization_207780() {
        this.config = ConstraintDescriptorTest.FixtureElement.build("constraintProvider", new String[][]{{"class", ConcurrencyTestProvider.class.getName()}, {"cache", "false"}});
        this.config.addChild(ConstraintDescriptorTest.FixtureElement.build("package", new String[][]{{"namespaceUri", "http:///ordersystem.ecore"}}));
        try {
            final ProviderDescriptor desc = new ProviderDescriptor((IConfigurationElement)this.config);
            final CyclicBarrier barrier = new CyclicBarrier(2);
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {}
                    desc.getProvider();
                }
            };
            Thread t1 = new Thread(run);
            Thread t2 = new Thread(run);
            t1.start();
            t2.start();
            t1.join();
            t2.join();
            ProviderDescriptorTest.assertFalse((String)"Provider initialized on two threads concurrently", (ConcurrencyTestProvider.count.get() >= 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            ProviderDescriptorTest.fail((String)("Caught exception: " + e.getLocalizedMessage()));
        }
    }

    static class ConcurrencyTestProvider
    extends AbstractConstraintProvider {
        static AtomicInteger count = new AtomicInteger(0);

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
            try {
                Thread.sleep(500L);
                count.incrementAndGet();
                Thread.sleep(500L);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.validation.tests", e.getLocalizedMessage()));
            }
            super.setInitializationData(config, propertyName, data);
        }
    }
}

