/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.toolkits.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.toolkits.Toolkit;
import org.eclipse.emf.eef.toolkits.ToolkitsPackage;
import org.eclipse.emf.eef.toolkits.parts.ToolkitPropertiesEditionPart;
import org.eclipse.emf.eef.toolkits.parts.ToolkitsViewsRepository;

public class ToolkitPropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";

    public ToolkitPropertiesEditionComponent(PropertiesEditingContext editingContext, EObject toolkit, String editing_mode) {
        super(editingContext, toolkit, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = ToolkitsViewsRepository.class;
        this.partKey = ToolkitsViewsRepository.Toolkit.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            Toolkit toolkit = (Toolkit)elt;
            ToolkitPropertiesEditionPart basePart = (ToolkitPropertiesEditionPart)this.editingPart;
            if (toolkit.getName() != null && this.isAccessible(ToolkitsViewsRepository.Toolkit.Properties.name)) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)toolkit.getName()));
            }
        }
        this.setInitializing(false);
    }

    protected EStructuralFeature associatedFeature(Object editorKey) {
        if (editorKey == ToolkitsViewsRepository.Toolkit.Properties.name) {
            return ToolkitsPackage.eINSTANCE.getToolkit_Name();
        }
        return super.associatedFeature(editorKey);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        Toolkit toolkit = (Toolkit)this.semanticObject;
        if (ToolkitsViewsRepository.Toolkit.Properties.name == event.getAffectedEditor()) {
            toolkit.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue())));
        }
    }

    public void updatePart(Notification msg) {
        if (this.editingPart.isVisible()) {
            ToolkitPropertiesEditionPart basePart = (ToolkitPropertiesEditionPart)this.editingPart;
            if (ToolkitsPackage.eINSTANCE.getToolkit_Name().equals(msg.getFeature()) && basePart != null && this.isAccessible(ToolkitsViewsRepository.Toolkit.Properties.name)) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
        }
    }

    public boolean isRequired(Object key, int kind) {
        return key == ToolkitsViewsRepository.Toolkit.Properties.name;
    }

    public String getHelpContent(Object key, int kind) {
        if (key == ToolkitsViewsRepository.Toolkit.Properties.name) {
            return "The name of the toolkit";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                if (ToolkitsViewsRepository.Toolkit.Properties.name == event.getAffectedEditor()) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EcoreUtil.createFromString((EDataType)ToolkitsPackage.eINSTANCE.getToolkit_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ToolkitsPackage.eINSTANCE.getToolkit_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

