/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.FormUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.SWTUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ReferencesTable
implements IPropertiesFilteredWidget {
    protected static final Image NEW_ELEMENT_IMG = EEFRuntimePlugin.getImage("icons/16x16/Add_16x16.gif");
    protected static final Image DELETE_ELEMENT_IMG = EEFRuntimePlugin.getImage("icons/16x16/Delete_16x16.gif");
    protected static final Image UP_ELEMENT_IMG = EEFRuntimePlugin.getImage("icons/16x16/ArrowUp_16x16.gif");
    protected static final Image DOWN_ELEMENT_IMG = EEFRuntimePlugin.getImage("icons/16x16/ArrowDown_16x16.gif");
    private Object input;
    private Label label;
    private Table table;
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private MouseListener addButtonlistener;
    private MouseListener removeButtonlistener;
    private MouseListener upButtonlistener;
    private MouseListener downButtonlistener;
    private Listener tableListener;
    private int upperBound = -1;
    private int lowerBound = 0;
    private ReferencesTableListener referencesTableListener;
    private String labelToDisplay;
    private FormToolkit widgetFactory;
    private Composite composite;
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private String helpText;
    protected List<ViewerFilter> bpFilters;
    protected List<ViewerFilter> filters;
    private IStructuredContentProvider contentProvider;

    public ReferencesTable(String labeltoDisplay, ReferencesTableListener referenceListener) {
        this.labelToDisplay = labeltoDisplay;
        this.addButtonlistener = new AddButtonlistener();
        this.removeButtonlistener = new RemoveButtonlistener();
        this.upButtonlistener = new UpButtonlistener();
        this.downButtonlistener = new DownButtonlistener();
        this.bpFilters = new ArrayList<ViewerFilter>();
        this.filters = new ArrayList<ViewerFilter>();
        this.addTableReferenceListener(referenceListener);
    }

    public void addTableReferenceListener(ReferencesTableListener referenceListener) {
        this.referencesTableListener = referenceListener;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.table.addSelectionListener(selectionListener);
    }

    public void createControls(Composite parent, FormToolkit widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.createControls(parent);
    }

    private Composite createComposite(Composite parent) {
        Composite composite = this.widgetFactory == null ? new Composite(parent, 0) : this.widgetFactory.createComposite(parent);
        return composite;
    }

    private Button createButton(Composite parent, String text, int style) {
        Button button;
        if (this.widgetFactory == null) {
            button = new Button(parent, style);
            button.setText(text);
        } else {
            button = this.widgetFactory.createButton(parent, text, style);
        }
        return button;
    }

    private Label createLabel(Composite parent, String text, int style) {
        Label label;
        if (this.widgetFactory == null) {
            label = new Label(parent, 8);
            label.setText(text);
        } else {
            label = this.widgetFactory.createLabel(parent, text, style);
        }
        return label;
    }

    private Table createTable(Composite parent, int style) {
        Table table = this.widgetFactory == null ? new Table(parent, style) : this.widgetFactory.createTable(parent, style);
        return table;
    }

    public void createControls(Composite parent) {
        this.composite = this.createComposite(parent);
        if (parent instanceof ExpandableComposite) {
            ((ExpandableComposite)parent).setClient((Control)this.composite);
        }
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 7;
        this.composite.setLayout((Layout)formLayout);
        FormData data = new FormData();
        data.top = new FormAttachment(-2, 0);
        data.right = new FormAttachment(100, -5);
        Control helpButton = null;
        if (this.helpText != null) {
            helpButton = this.widgetFactory != null ? FormUtils.createHelpButton(this.widgetFactory, this.composite, this.helpText, null) : SWTUtils.createHelpButton(this.composite, this.helpText, null);
            helpButton.setLayoutData((Object)data);
        }
        this.removeButton = this.createButton(this.composite, "", 8);
        this.removeButton.setVisible(true);
        this.removeButton.setImage(DELETE_ELEMENT_IMG);
        this.removeButton.setToolTipText(EEFRuntimeUIMessages.ReferencesTable_remove_tooltip);
        data = new FormData();
        data.top = new FormAttachment(-6, 0);
        data.right = this.helpText != null ? new FormAttachment(helpButton, -5) : new FormAttachment(100, -5);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addMouseListener(this.removeButtonlistener);
        this.addButton = this.createButton(this.composite, "", 8);
        this.addButton.setVisible(true);
        this.addButton.setImage(NEW_ELEMENT_IMG);
        this.addButton.setToolTipText(EEFRuntimeUIMessages.ReferencesTable_add_tooltip);
        data = new FormData();
        data.top = new FormAttachment(-6, 0);
        data.right = new FormAttachment((Control)this.removeButton, -5);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addMouseListener(this.addButtonlistener);
        this.upButton = this.createButton(this.composite, "", 8);
        this.upButton.setVisible(true);
        this.upButton.setImage(UP_ELEMENT_IMG);
        this.upButton.setToolTipText(EEFRuntimeUIMessages.ReferencesTable_up_tooltip);
        data = new FormData();
        data.top = new FormAttachment(-6, 0);
        data.right = new FormAttachment((Control)this.addButton, -5);
        this.upButton.setLayoutData((Object)data);
        this.upButton.addMouseListener(this.upButtonlistener);
        this.downButton = this.createButton(this.composite, "", 8);
        this.downButton.setVisible(true);
        this.downButton.setImage(DOWN_ELEMENT_IMG);
        this.downButton.setToolTipText(EEFRuntimeUIMessages.ReferencesTable_down_tooltip);
        data = new FormData();
        data.top = new FormAttachment(-6, 0);
        data.right = new FormAttachment((Control)this.upButton, -5);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addMouseListener(this.downButtonlistener);
        this.label = this.createLabel(this.composite, this.labelToDisplay, 0);
        data = new FormData();
        data.left = new FormAttachment(2, 0);
        data.right = new FormAttachment((Control)this.downButton, -10);
        data.top = new FormAttachment(0, 0);
        this.label.setLayoutData((Object)data);
        this.table = this.createTable(this.composite, 2306);
        this.table.setLayout((Layout)new FormLayout());
        this.table.setVisible(true);
        this.tableListener = new EditItemListener();
        this.table.addListener(8, this.tableListener);
        this.tableViewer = new TableViewer(this.table);
        data = new FormData();
        data.height = 100;
        data.top = new FormAttachment((Control)this.label, 8);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.table.setLayoutData((Object)data);
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ReferencesTable.this.table.getSelection() != null && ReferencesTable.this.table.getSelectionCount() != 0 && ReferencesTable.this.table.getSelection()[0].getData() instanceof EObject) {
                    ReferencesTable.this.referencesTableListener.navigateTo((EObject)ReferencesTable.this.table.getSelection()[0].getData());
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setUpperBound(int value) {
        this.upperBound = value < 0 ? -1 : value;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setLowerBound(int value) {
        this.lowerBound = value <= 0 ? 0 : value;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    private int getSize() {
        if (this.contentProvider != null && this.input != null) {
            return this.contentProvider.getElements(this.input).length;
        }
        return -1;
    }

    private int indexOf(Object elem) {
        Object[] elements = this.contentProvider.getElements(this.input);
        int i = 0;
        while (i < elements.length) {
            Object next = elements[i];
            if (next.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.table, id);
        EditingUtils.setID((Control)this.addButton, id);
        EditingUtils.setID((Control)this.removeButton, id);
        EditingUtils.setID((Control)this.upButton, id);
        EditingUtils.setID((Control)this.downButton, id);
    }

    public void setEEFType(String type) {
        EditingUtils.setEEFtype((Control)this.table, String.valueOf(type) + "::field");
        EditingUtils.setEEFtype((Control)this.addButton, String.valueOf(type) + "::addbutton");
        EditingUtils.setEEFtype((Control)this.removeButton, String.valueOf(type) + "::removebutton");
        EditingUtils.setEEFtype((Control)this.upButton, String.valueOf(type) + "::upbutton");
        EditingUtils.setEEFtype((Control)this.downButton, String.valueOf(type) + "::downbutton");
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.table);
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.computeAddButtonStatus();
        this.computeRemoveButtonStatus();
    }

    private void computeRemoveButtonStatus() {
        if (this.getSize() > this.lowerBound) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private void computeAddButtonStatus() {
        if (this.upperBound < 0 || this.getSize() < this.upperBound) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void initLabelProvider() {
        if (!this.table.isDisposed()) {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        }
    }

    public AdapterFactoryLabelProvider getLabelProvider() {
        return new AdapterFactoryLabelProvider(this.adapterFactory);
    }

    public void disableMove() {
        this.upButton.setVisible(false);
        this.downButton.setVisible(false);
    }

    public void dispose() {
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.removeMouseListener(this.addButtonlistener);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.removeMouseListener(this.removeButtonlistener);
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            this.upButton.removeMouseListener(this.upButtonlistener);
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            this.downButton.removeMouseListener(this.downButtonlistener);
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeListener(8, this.tableListener);
        }
        if (this.filters != null) {
            this.filters.clear();
            this.filters = null;
        }
        if (this.bpFilters != null) {
            this.bpFilters.clear();
            this.bpFilters = null;
        }
    }

    public void setInput(Object input) {
        this.input = input;
        this.initLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setInput(input);
        for (ViewerFilter filter : this.filters) {
            this.tableViewer.addFilter(filter);
        }
        for (ViewerFilter filter : this.bpFilters) {
            this.tableViewer.addFilter(filter);
        }
        this.computeAddButtonStatus();
        this.computeRemoveButtonStatus();
    }

    public Object getInput() {
        return this.input;
    }

    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.bpFilters.add(filter);
        if (this.tableViewer != null) {
            this.tableViewer.addFilter(filter);
            this.tableViewer.refresh();
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
        if (this.tableViewer != null) {
            this.tableViewer.addFilter(filter);
            this.tableViewer.refresh();
        }
    }

    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.bpFilters.remove(filter);
        if (this.tableViewer != null) {
            this.tableViewer.removeFilter(filter);
            this.tableViewer.refresh();
        }
    }

    public void removeFilter(ViewerFilter filter) {
        this.filters.remove(filter);
        if (this.tableViewer != null) {
            this.tableViewer.removeFilter(filter);
            this.tableViewer.refresh();
        }
    }

    protected void refreshFilters() {
    }

    public void setEnabled(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
    }

    public void setToolTipText(String tooltip) {
        this.addButton.setToolTipText(tooltip);
        this.downButton.setToolTipText(tooltip);
        this.removeButton.setToolTipText(tooltip);
        this.table.setToolTipText(tooltip);
        this.upButton.setToolTipText(tooltip);
    }

    public Table getTable() {
        return this.table;
    }

    private class AddButtonlistener
    implements MouseListener {
        private AddButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ReferencesTable.this.referencesTableListener.handleAdd();
        }
    }

    private class DownButtonlistener
    implements MouseListener {
        private DownButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            TableItem[] tableItems = ReferencesTable.this.table.getSelection();
            int i = tableItems.length - 1;
            while (i >= 0) {
                int newIndex = ReferencesTable.this.indexOf(tableItems[i].getData()) + 1;
                if (newIndex >= 0 && newIndex < ReferencesTable.this.getSize()) {
                    ReferencesTable.this.referencesTableListener.handleMove((EObject)tableItems[i].getData(), newIndex - 1, newIndex);
                }
                --i;
            }
        }
    }

    private class EditItemListener
    implements Listener {
        private EditItemListener() {
        }

        public void handleEvent(Event event) {
            if (ReferencesTable.this.table.getSelection().length > 0) {
                TableItem item = ReferencesTable.this.table.getSelection()[0];
                ReferencesTable.this.referencesTableListener.handleEdit((EObject)item.getData());
            }
        }
    }

    public static interface ReferencesTableListener {
        public void handleAdd();

        public void handleRemove(EObject var1);

        public void handleMove(EObject var1, int var2, int var3);

        public void handleEdit(EObject var1);

        public void navigateTo(EObject var1);
    }

    private class RemoveButtonlistener
    implements MouseListener {
        private RemoveButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            TableItem[] tableItems = ReferencesTable.this.table.getSelection();
            int i = tableItems.length - 1;
            while (i >= 0) {
                ReferencesTable.this.referencesTableListener.handleRemove((EObject)tableItems[i].getData());
                --i;
            }
        }
    }

    private class UpButtonlistener
    implements MouseListener {
        private UpButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            TableItem[] tableItems = ReferencesTable.this.table.getSelection();
            int i = tableItems.length - 1;
            while (i >= 0) {
                int newIndex = ReferencesTable.this.indexOf(tableItems[i].getData()) - 1;
                if (newIndex >= 0 && newIndex < ReferencesTable.this.getSize()) {
                    ReferencesTable.this.referencesTableListener.handleMove((EObject)tableItems[i].getData(), newIndex + 1, newIndex);
                }
                --i;
            }
        }
    }
}

