/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.part.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IFormPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.parts.CompositePropertiesEditionPart;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.part.impl.util.ValidationMessageInjector;
import org.eclipse.emf.eef.runtime.ui.parts.impl.BindingViewHelper;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionMessageManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SectionPropertiesEditingPart
extends CompositePropertiesEditionPart
implements IFormPropertiesEditionPart,
ISection {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private EditingDomain editingDomain;
    protected EObject eObject;
    protected List<?> eObjectList;
    protected Composite container;
    private boolean usedAsPropertySection;
    private PropertiesEditionMessageManager messageManager;
    private Composite editingComposite;
    private ValidationMessageInjector injector;

    protected SectionPropertiesEditingPart() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    public SectionPropertiesEditingPart(IPropertiesEditionComponent editionComponent) {
        super(editionComponent);
        this.usedAsPropertySection = false;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.tabbedPropertySheetPage = tabbedPropertySheetPage;
        this.container = tabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        this.container.setLayout((Layout)new GridLayout(3, false));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject;
        this.initializeEditingDomain(part);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement()) != null && (newEObject = this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement())) != this.eObject) {
            this.eObject = newEObject;
            if (this.eObject != null) {
                this.injector = new ValidationMessageInjector(this.tabbedPropertySheetPage);
                this.messageManager = new PropertiesEditionMessageManager(){

                    protected void updateStatus(String message) {
                        if (SectionPropertiesEditingPart.this.injector != null) {
                            SectionPropertiesEditingPart.this.injector.setMessage(message, 0);
                        }
                    }

                    protected void updateError(String message) {
                        if (SectionPropertiesEditingPart.this.injector != null) {
                            SectionPropertiesEditingPart.this.injector.setMessage(message, 4);
                        }
                    }

                    protected void updateWarning(String message) {
                        if (SectionPropertiesEditingPart.this.injector != null) {
                            SectionPropertiesEditingPart.this.injector.setMessage(message, 2);
                        }
                    }
                };
                this.disposeComponent();
                this.refreshComponent();
            }
        }
        this.eObjectList = ((IStructuredSelection)selection).toList();
        this.usedAsPropertySection = true;
    }

    @Override
    public void refresh() {
        if (this.usedAsPropertySection) {
            this.initSemanticContents();
        } else {
            super.refresh();
        }
    }

    private void initializeEditingDomain(IWorkbenchPart part) {
        this.editingDomain = EditingUtils.getResourceSetFromEditor(part);
    }

    protected EObject resolveSemanticObject(Object object) {
        return EEFUtils.resolveSemanticObject(object);
    }

    private void refreshComponent() {
        DomainPropertiesEditionContext propertiesEditingContext = new DomainPropertiesEditionContext(null, null, this.editingDomain, this.adapterFactory, this.eObject);
        this.propertiesEditionComponent = propertiesEditingContext.createPropertiesEditingComponent("Live", this.getDescriptor());
        if (this.propertiesEditionComponent != null) {
            this.adapterFactory = this.propertiesEditionComponent.getEditingContext().getAdapterFactory();
            propertiesEditingContext.setHelper(new BindingViewHelper(propertiesEditingContext, (FormToolkit)this.tabbedPropertySheetPage.getWidgetFactory()));
            this.propertiesEditionComponent.setPropertiesEditionPart(this.propertiesEditionComponent.translatePart(this.getDescriptor()), 0, this);
            this.propertiesEditionComponent.setLiveEditingDomain(this.editingDomain);
            if (this.editingComposite != null) {
                this.editingComposite.dispose();
            }
            this.editingComposite = this.createFigure(this.container, (FormToolkit)this.tabbedPropertySheetPage.getWidgetFactory());
            if (this.editingComposite != null) {
                this.editingComposite.setLayoutData((Object)new GridData(1808));
                this.container.layout();
            }
            if (this.messageManager != null) {
                this.messageManager.processMessage(new PropertiesValidationEditionEvent(null, Diagnostic.OK_INSTANCE));
                this.propertiesEditionComponent.addListener(new IPropertiesEditionListener(){

                    public void firePropertiesChanged(IPropertiesEditionEvent event) {
                        SectionPropertiesEditingPart.this.messageManager.processMessage(event);
                    }
                });
            }
        }
    }

    protected void initSemanticContents() {
        this.propertiesEditionComponent.initPart(this.propertiesEditionComponent.translatePart(this.getDescriptor()), 1, this.eObject);
    }

    public void aboutToBeShown() {
    }

    public void aboutToBeHidden() {
        if (this.injector != null) {
            this.injector.dispose();
            this.injector = null;
        }
    }

    public void dispose() {
        this.disposeComponent();
    }

    private void disposeComponent() {
        if (this.propertiesEditionComponent != null) {
            PropertiesEditingContext editingContext = this.propertiesEditionComponent.getEditingContext();
            if (editingContext != null && editingContext.getParentContext() == null) {
                editingContext.dispose();
            }
            this.propertiesEditionComponent.dispose();
        }
    }

    public int getMinimumHeight() {
        return -1;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    protected String getDescriptor() {
        Map<?, ?> descriptor = this.getPageDescriptor(this.tabbedPropertySheetPage);
        for (Object key : descriptor.keySet()) {
            Method getId;
            Object result;
            Object tab = descriptor.get(key);
            Method getSectionAtIndex = this.getMethod(tab, "getSectionAtIndex", Integer.TYPE);
            if (getSectionAtIndex == null || (result = this.callMethod(tab, getSectionAtIndex, new Integer(0))) != this || (getId = this.getMethod(key, "getId", new Class[0])) == null) continue;
            String id = (String)this.callMethod(key, getId, new Object[0]);
            return id;
        }
        return "";
    }

    private Map<?, ?> getPageDescriptor(TabbedPropertySheetPage propertySheetPage) {
        Field descriptorToTabField = null;
        boolean oldAccessible = false;
        try {
            Class<?> cls = propertySheetPage.getClass();
            while (!cls.equals(TabbedPropertySheetPage.class)) {
                cls = cls.getSuperclass();
            }
            descriptorToTabField = cls.getDeclaredField("descriptorToTab");
            oldAccessible = descriptorToTabField.isAccessible();
            descriptorToTabField.setAccessible(true);
            Map map = (Map)descriptorToTabField.get(propertySheetPage);
            return map;
        }
        catch (SecurityException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (NoSuchFieldException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (IllegalArgumentException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (IllegalAccessException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        finally {
            if (descriptorToTabField != null) {
                descriptorToTabField.setAccessible(oldAccessible);
            }
        }
        return null;
    }

    private Method getMethod(Object source, String name, Class<?> ... argsType) {
        try {
            return source.getClass().getDeclaredMethod(name, argsType);
        }
        catch (Exception e) {
            EEFRuntimePlugin.getDefault().logError(String.valueOf(EEFRuntimeUIMessages.PropertiesEditionSection_method_not_found) + name, e);
            return null;
        }
    }

    private Object callMethod(Object source, Method method, Object ... args) {
        try {
            return method.invoke(source, args);
        }
        catch (Exception e) {
            EEFRuntimePlugin.getDefault().logError(String.valueOf(EEFRuntimeUIMessages.PropertiesEditionSection_error_occured_on) + method.getName() + EEFRuntimeUIMessages.PropertiesEditionSection_call, e);
            return null;
        }
    }
}

