/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.core.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;

public class BundleHelper {
    private static final String MANIFEST_FILE_PATH = "META-INF/MANIFEST.MF";
    private IProject bundleProject;
    private BundlePluginModel pluginModel;

    public BundleHelper(IProject bundleProject) {
        this.bundleProject = bundleProject;
    }

    public BundlePluginModel getBundlePluginModel() {
        if (this.pluginModel == null) {
            IFile manifest = this.bundleProject.getFile((IPath)new Path(MANIFEST_FILE_PATH));
            WorkspaceBundleModel bModel = new WorkspaceBundleModel(manifest);
            bModel.load();
            this.pluginModel = new BundlePluginModel();
            this.pluginModel.setBundleModel((IBundleModel)bModel);
        }
        return this.pluginModel;
    }

    public void addDependency(String bundleToAdd) throws CoreException {
        IPluginBase pluginBase = this.getBundlePluginModel().getPluginBase();
        IPluginImport createImport = ((BundlePluginModelBase)this.getBundlePluginModel().getPluginFactory()).createImport(bundleToAdd);
        createImport.setReexported(true);
        pluginBase.add(createImport);
        this.getBundlePluginModel().save();
    }
}

