/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceManagerImpl;

public class MultiThreadedStateSpaceManager
extends StateSpaceManagerImpl {
    private int numWorkers;
    private ExecutorService executor;
    private Future<StateSpaceException>[] futures;
    private Thread preparer;
    private Map<State, List<Transition>> preparedStates;
    private long lastExplorationCall;

    public MultiThreadedStateSpaceManager(StateSpace stateSpace, int numThreads) {
        super(stateSpace);
        this.numWorkers = Math.max(numThreads, 1);
        this.executor = Executors.newFixedThreadPool(this.numWorkers);
        this.futures = new Future[this.numWorkers];
        this.preparedStates = Collections.synchronizedMap(new HashMap());
    }

    public MultiThreadedStateSpaceManager(StateSpace stateSpace) {
        this(stateSpace, Runtime.getRuntime().availableProcessors());
    }

    @Override
    public synchronized List<State> exploreStates(List<State> states, boolean generateLocations) throws StateSpaceException {
        this.lastExplorationCall = System.currentTimeMillis();
        if (this.preparer == null) {
            this.preparer = new Thread(new PreparationWorker());
            this.preparer.start();
        }
        Vector<State> queue = new Vector<State>(states);
        Vector<State> result = new Vector<State>();
        try {
            int i = 0;
            while (i < this.numWorkers) {
                this.futures[i] = this.executor.submit(new ExplorationWorker(queue, result, generateLocations));
                ++i;
            }
            i = 0;
            while (i < this.numWorkers) {
                if (this.futures[i].get() != null) {
                    throw this.futures[i].get();
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        return result;
    }

    @Override
    protected List<Transition> doExplore(State state) throws StateSpaceException {
        List<Transition> result = this.preparedStates.get(state);
        if (result == null) {
            result = super.doExplore(state);
            this.preparedStates.put(state, result);
        }
        return result;
    }

    @Override
    public void clearStateModelCache() {
        super.clearStateModelCache();
        this.preparedStates.clear();
        System.gc();
    }

    private StateSpaceException wrapException(Throwable t) {
        return t instanceof StateSpaceException ? (StateSpaceException)t : new StateSpaceException(t);
    }

    private class ExplorationWorker
    implements Callable<StateSpaceException> {
        private List<State> states;
        private List<State> result;
        private boolean generateLocations;

        ExplorationWorker(List<State> states, List<State> result, boolean generateLocations) {
            this.states = states;
            this.result = result;
            this.generateLocations = generateLocations;
        }

        @Override
        public StateSpaceException call() {
            while (true) {
                State next;
                try {
                    next = this.states.remove(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                try {
                    this.result.addAll(MultiThreadedStateSpaceManager.this.exploreState(next, this.generateLocations));
                    MultiThreadedStateSpaceManager.this.preparedStates.remove(next);
                }
                catch (Throwable t) {
                    return MultiThreadedStateSpaceManager.this.wrapException(t);
                }
            }
        }
    }

    private class PreparationWorker
    implements Runnable {
        private PreparationWorker() {
        }

        @Override
        public void run() {
            block2: while (true) {
                State[] open = this.getOpenStates();
                int i = 0;
                while (true) {
                    if (i >= open.length) continue block2;
                    try {
                        if (open[i] != null) {
                            MultiThreadedStateSpaceManager.this.doExplore(open[i]);
                        }
                        if (i % 100 == 0) {
                            Thread.sleep(100L);
                        }
                        if (i % 1000 == 0 && System.currentTimeMillis() - MultiThreadedStateSpaceManager.this.lastExplorationCall > 3000L) {
                            MultiThreadedStateSpaceManager.this.preparer = null;
                            return;
                        }
                    }
                    catch (Throwable throwable) {}
                    ++i;
                }
                break;
            }
        }

        private State[] getOpenStates() {
            while (true) {
                try {
                    return MultiThreadedStateSpaceManager.this.getStateSpace().getOpenStates().toArray(new State[0]);
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

