/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.EdgeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeDeleteCommand
extends AbstractTransactionalCommand {
    private Edge edge;

    public EdgeDeleteCommand(TransactionalEditingDomain domain, Edge edge) {
        super(domain, "Delete Edge", null);
        this.edge = edge;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.edge.getGraph() == null || this.edge.getGraph().getContainerRule() == null) {
            return CommandResult.newErrorCommandResult((String)"Edge not contained in graph / rule");
        }
        Rule rule = this.edge.getGraph().getContainerRule();
        Action action = EdgeActionHelper.INSTANCE.getAction(this.edge);
        if (action == null) {
            this.edge.getGraph().removeEdge(this.edge);
            return CommandResult.newWarningCommandResult((String)"Edge seems to be illegal. Deleted anyway.", null);
        }
        this.doRemove(HenshinMappingUtil.getEdgeImage((Edge)this.edge, (Graph)rule.getRhs(), (List)rule.getMappings()));
        for (NestedCondition nac : HenshinNACUtil.getAllNACs((Rule)rule)) {
            this.doRemove(HenshinMappingUtil.getEdgeImage((Edge)this.edge, (Graph)nac.getConclusion(), (List)nac.getMappings()));
        }
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(rule);
        if (amalgamation != null) {
            for (Rule multi : amalgamation.getMultiRules()) {
                this.doRemove(HenshinMappingUtil.getEdgeImage((Edge)this.edge, (Graph)multi.getLhs(), (List)amalgamation.getLhsMappings()));
            }
        }
        this.doRemove(this.edge);
        HenshinNACUtil.removeTrivialNACs((Rule)rule);
        AmalgamationEditHelper.cleanUpAmalagamation(rule);
        return CommandResult.newOKCommandResult();
    }

    private void doRemove(Edge edge) throws ExecutionException {
        if (edge == null) {
            return;
        }
        Node source = edge.getSource();
        Node target = edge.getTarget();
        EReference type = edge.getType();
        Rule rule = edge.getGraph().getContainerRule();
        edge.getGraph().removeEdge(edge);
        if (type != null && (type.isContainment() || type.isContainer())) {
            View ruleView = RootObjectEditHelper.findRuleView(rule);
            RootObjectEditHelper.updateRootContainment(ruleView, source);
            RootObjectEditHelper.updateRootContainment(ruleView, target);
        }
    }
}

