/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeTypeParserHelper {
    private final Pattern PATTERN_NODE_NAME = Pattern.compile("^(?:([^,:]*)(?:,([^,:]*))?)?(?::([\\w\\.]+))?$");
    private final Pattern PATTERN_PARAMETER = Pattern.compile("^([^\\[\\]]+)(?:\\[([^\\[\\]]*)\\])?$", 2);
    private String[] para = new String[2];
    private ParameterDirection[] paraDirection = new ParameterDirection[2];
    private String type;

    public NodeTypeParserHelper() {
        this.initialize();
    }

    public boolean parse(String nodeString) {
        this.initialize();
        if (this.isUndefined(nodeString)) {
            return false;
        }
        Matcher matcher = this.PATTERN_NODE_NAME.matcher(nodeString = nodeString.trim());
        if (!matcher.matches()) {
            return false;
        }
        this.type = matcher.group(3);
        this.type = this.isUndefined(this.type) ? null : this.type.trim();
        String p = matcher.group(1);
        this.parseParameterString(p, 0);
        p = matcher.group(2);
        this.parseParameterString(p, 1);
        if (this.para[0] == null && this.para[1] != null) {
            this.para[0] = this.para[1];
            this.para[1] = null;
            this.paraDirection[0] = this.paraDirection[1];
            this.paraDirection[1] = null;
        }
        if (this.para[0] != null && this.paraDirection[0] == this.paraDirection[1]) {
            this.para[1] = null;
            this.paraDirection[1] = null;
        }
        if (this.para[0] != null && this.para[1] != null && (this.paraDirection[0].equals((Object)ParameterDirection.INOUT) || this.paraDirection[1].equals((Object)ParameterDirection.INOUT))) {
            this.para[1] = null;
            this.paraDirection[1] = null;
        }
        return true;
    }

    private void parseParameterString(String value, int paraNo) {
        String pName;
        Matcher m;
        if (!this.isUndefined(value) && (m = this.PATTERN_PARAMETER.matcher(value = value.trim())).matches() && !this.isUndefined(pName = m.group(1))) {
            this.para[paraNo] = pName.trim();
            String pDir = m.group(2);
            this.paraDirection[paraNo] = ParameterDirection.get(pDir);
        }
    }

    private void initialize() {
        this.para[0] = null;
        this.para[1] = null;
        this.paraDirection[0] = null;
        this.paraDirection[1] = null;
        this.type = null;
    }

    private boolean isUndefined(String s) {
        return s == null || s.trim().length() == 0;
    }

    public String getType() {
        return this.type;
    }

    public String getParameter1() {
        return this.para[0];
    }

    public String getParameter2() {
        return this.para[1];
    }

    public ParameterDirection getDirection1() {
        return this.paraDirection[0];
    }

    public ParameterDirection getDirection2() {
        return this.paraDirection[1];
    }

    public String getParameterString(String para1Name, ParameterDirection para1Dir, String para2Name, ParameterDirection para2Dir) {
        String p1 = null;
        String p2 = null;
        String result = "";
        if (para1Name == null || para1Name.trim().isEmpty()) {
            return result;
        }
        p1 = para1Name;
        if (para1Dir != ParameterDirection.INOUT) {
            p1 = String.valueOf(p1) + "[" + para1Dir.id + "]";
            if (para2Name != null && !para2Name.trim().isEmpty()) {
                p2 = String.valueOf(para2Name) + "[" + para2Dir.id + "]";
                result = para1Dir == ParameterDirection.IN ? String.valueOf(p1) + "," + p2 : String.valueOf(p2) + "," + p1;
            } else {
                result = p1;
            }
        } else {
            result = p1;
        }
        return result;
    }

    public static enum ParameterDirection {
        IN("in"),
        OUT("out"),
        INOUT("");

        public String id;

        private ParameterDirection(String id) {
            this.id = id;
        }

        public static final ParameterDirection get(String id) {
            if (id == null || id.isEmpty()) {
                return INOUT;
            }
            if (id.trim().toLowerCase().equals(ParameterDirection.IN.id)) {
                return IN;
            }
            if (id.trim().toLowerCase().equals(ParameterDirection.OUT.id)) {
                return OUT;
            }
            return INOUT;
        }
    }
}

