/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.ui.InterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.wizard.Henshination;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationException;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterConfiguration;
import org.eclipse.emf.henshin.interpreter.ui.wizard.widgets.ModelSelector;
import org.eclipse.emf.henshin.interpreter.ui.wizard.widgets.ParameterEditTable;
import org.eclipse.emf.henshin.interpreter.ui.wizard.widgets.UnitSelector;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HenshinWizard
extends Wizard
implements UnitSelector.UnitSelectionListener,
ModelSelector.ModelSelectorListener,
ParameterEditTable.ParameterChangeListener {
    protected static int CONTROL_OFFSET = 5;
    protected UnitSelector unitSelector;
    protected ModelSelector modelSelector;
    protected ParameterEditTable parameterEditor;
    protected TransformationUnit initialUnit;
    protected TransformationSystem transformationSystem;
    protected ArrayList<TransformationUnit> availableUnits;
    protected Collection<CompletionListener> completionListeners = new ArrayList<CompletionListener>();
    protected boolean uriFieldDirty = false;
    protected Henshination cfg;
    protected Button saveOnCancel;
    protected WizardPage page;
    protected IPreferenceStore store = InterpreterUIPlugin.getPlugin().getPreferenceStore();
    protected boolean unitSelectable = true;

    public HenshinWizard(TransformationUnit tUnit) {
        this();
        this.unitSelectable = false;
        this.initialUnit = tUnit;
        this.transformationSystem = (TransformationSystem)tUnit.eContainer();
    }

    public HenshinWizard(TransformationSystem tSystem) {
        this();
        this.unitSelectable = true;
        this.transformationSystem = tSystem;
    }

    private HenshinWizard() {
        this.setWindowTitle(InterpreterUIPlugin.LL("_UI_Wizard"));
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)InterpreterUIPlugin.INSTANCE.getImage("Henshin_small.png"))));
    }

    protected String getUnitLabel(TransformationUnit unit) {
        return String.valueOf(unit.getName()) + "[" + unit.eClass().getName() + "]";
    }

    protected void initData() {
        ResourceSetImpl rs = new ResourceSetImpl();
        URI trafoUri = this.transformationSystem.eResource().getURI();
        Resource r = rs.createResource(trafoUri);
        try {
            r.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.transformationSystem = (TransformationSystem)r.getContents().get(0);
        if (this.initialUnit != null) {
            String id = this.initialUnit.eResource().getURIFragment((EObject)this.initialUnit);
            ArrayList l = new ArrayList(this.transformationSystem.getRules());
            l.addAll(this.transformationSystem.getTransformationUnits());
            for (TransformationUnit unit : l) {
                if (!r.getURIFragment((EObject)unit).equals(id)) continue;
                this.initialUnit = unit;
                break;
            }
        }
        this.availableUnits = new ArrayList();
        this.availableUnits.addAll((Collection<TransformationUnit>)this.transformationSystem.getTransformationUnits());
        this.availableUnits.addAll((Collection<TransformationUnit>)this.transformationSystem.getRules());
        ArrayList<String> unitLabels = new ArrayList<String>();
        int initIdx = -1;
        int idx = 0;
        TransformationUnit selectedUnit = this.initialUnit;
        for (TransformationUnit unit : this.availableUnits) {
            unitLabels.add(this.getUnitLabel(unit));
            if (this.initialUnit != null) {
                if (this.initialUnit == unit) {
                    initIdx = idx;
                    selectedUnit = unit;
                }
            } else if (initIdx < 0 && unit.getName() != null && unit.getName().toLowerCase().equals("main")) {
                initIdx = idx;
                selectedUnit = unit;
            }
            ++idx;
        }
        if (initIdx < 0) {
            initIdx = 0;
            selectedUnit = this.availableUnits.get(0);
        }
        this.unitSelector.setSelectableUnits(unitLabels.toArray(new String[0]));
        this.unitSelector.setSelection(initIdx);
        this.unitSelector.setEnabled(this.initialUnit == null);
        List<String> lastUsedModels = this.getModelPreferences();
        this.cfg = new Henshination();
        if (selectedUnit != null) {
            this.cfg.setTransformationUnit(selectedUnit, this.getParameterPreferences(selectedUnit));
        }
        if (lastUsedModels.get(0).length() > 0) {
            this.cfg.setModelUri(URI.createURI((String)lastUsedModels.get(0)));
        }
        this.modelSelector.setLastUsedModels(lastUsedModels.toArray(new String[0]));
        if (selectedUnit != null) {
            this.parameterEditor.setParameters(this.cfg.getParameterConfigurations());
        }
        this.unitSelector.addUnitSelectionListener(this);
        this.modelSelector.addModelSelectorListener(this);
        this.parameterEditor.addParameterChangeListener(this);
    }

    protected List<ParameterConfiguration> getParameterPreferences(TransformationUnit unit) {
        ArrayList<ParameterConfiguration> result = new ArrayList<ParameterConfiguration>();
        for (Parameter param : unit.getParameters()) {
            result.add(ParameterConfiguration.loadConfiguration(this.store, param.getName()));
        }
        return result;
    }

    protected List<String> getModelPreferences() {
        ArrayList<String> lastUsedModels = new ArrayList<String>();
        int i = 0;
        while (i < 5) {
            lastUsedModels.add(this.store.getString("model_" + i));
            ++i;
        }
        return lastUsedModels;
    }

    public void addPages() {
        this.page = new WizardPage(InterpreterUIPlugin.LL("_UI_PseudoPage")){
            {
                this.setDescription(InterpreterUIPlugin.LL("_UI_Wizard_DefaultDescription"));
            }

            public void createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                container.setLayout((Layout)new FormLayout());
                GridData data = new GridData();
                data.verticalAlignment = 4;
                data.grabExcessVerticalSpace = true;
                data.horizontalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
                container.setLayoutData((Object)data);
                HenshinWizard.this.unitSelector = new UnitSelector(container);
                data = new FormData();
                data.top = new FormAttachment(0, CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                HenshinWizard.this.unitSelector.getControl().setLayoutData((Object)data);
                HenshinWizard.this.modelSelector = new ModelSelector(container);
                data = new FormData();
                data.top = new FormAttachment(HenshinWizard.this.unitSelector.getControl(), CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                HenshinWizard.this.modelSelector.getControl().setLayoutData((Object)data);
                HenshinWizard.this.parameterEditor = new ParameterEditTable(container);
                data = new FormData();
                data.top = new FormAttachment(HenshinWizard.this.modelSelector.getControl(), CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                data.bottom = new FormAttachment(100, -CONTROL_OFFSET);
                HenshinWizard.this.parameterEditor.getControl().setLayoutData((Object)data);
                this.setControl((Control)container);
            }
        };
        this.addPage((IWizardPage)this.page);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.initData();
    }

    public boolean canFinish() {
        if (this.uriFieldDirty) {
            this.page.setMessage(InterpreterUIPlugin.LL("_UI_CheckResourceRequired"), 2);
            return false;
        }
        this.page.setMessage(null);
        if (this.cfg.getModelUri() == null || this.cfg.getTransformationUnit() == null) {
            return false;
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            if (this.cfg.getModel() == null) {
                return false;
            }
        }
        catch (Exception e) {
            errors.add(e.getMessage());
        }
        if (!this.cfg.getTransformationUnit().isActivated()) {
            errors.add(InterpreterUIPlugin.LL("_UI_Status_TransforamtionUnitNotActivated"));
        }
        if (errors.size() == 0) {
            this.page.setErrorMessage(null);
            if (!this.cfg.isModelAffectedByTransformation()) {
                this.page.setMessage(InterpreterUIPlugin.LL("_UI_Status_TransformationDoesNotAffectModel"), 2);
            } else {
                this.page.setMessage(null);
            }
            return true;
        }
        StringBuffer err = new StringBuffer();
        err.append(errors.size() > 1 ? InterpreterUIPlugin.LL("_UI_Status_MultipleErrors") : InterpreterUIPlugin.LL("_UI_Status_SingleError"));
        for (String errString : errors) {
            err.append("\n - " + errString);
        }
        this.page.setErrorMessage(err.toString());
        return false;
    }

    public void performPreview() {
        try {
            this.cfg.createPreview().showDialog(this.getShell());
        }
        catch (HenshinationException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)InterpreterUIPlugin.LL("_UI_HenshinationException_Title"), (String)InterpreterUIPlugin.LL("_UI_HenshinationException_Msg"), (IStatus)new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage()));
        }
    }

    public boolean performFinish() {
        try {
            OperationHistoryFactory.getOperationHistory().execute(this.cfg.getUndoableOperation(), null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.saveSettings();
        return true;
    }

    public boolean performCancel() {
        if (this.store.getBoolean("saveOnCancel")) {
            this.saveSettings();
        }
        return true;
    }

    protected void saveSettings() {
        if (this.cfg.getModelUri() != null) {
            String newModel = this.cfg.getModelUri().toString();
            List<String> models = this.getModelPreferences();
            models.remove(newModel);
            models.add(0, newModel);
            int i = 0;
            while (i < 5) {
                this.store.setValue("model_" + i, models.get(i));
                ++i;
            }
        }
        for (ParameterConfiguration paramCfg : this.cfg.getParameterConfigurations()) {
            paramCfg.persist(this.store);
        }
    }

    @Override
    public boolean unitSelected(int idx) {
        TransformationUnit unit = this.availableUnits.get(idx);
        this.cfg.setTransformationUnit(unit, this.getParameterPreferences(unit));
        this.parameterEditor.setParameters(this.cfg.getParameterConfigurations());
        this.fireCompletionChange();
        return false;
    }

    @Override
    public boolean modelURIChanged(URI modelUri) {
        this.cfg.setModelUri(modelUri);
        this.uriFieldDirty = false;
        this.fireCompletionChange();
        return false;
    }

    @Override
    public void parameterChanged(ParameterConfiguration paramCfg) {
        this.fireCompletionChange();
    }

    @Override
    public void uriFieldDirty() {
        this.uriFieldDirty = true;
        this.fireCompletionChange();
    }

    protected void fireCompletionChange() {
        for (CompletionListener l : this.completionListeners) {
            l.completionChanged();
        }
    }

    public void addCompletionListener(CompletionListener listener) {
        this.completionListeners.add(listener);
    }

    public static interface CompletionListener {
        public void completionChanged();
    }
}

