/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceExporter;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.external.prism.RatesPropertiesManager;

public class PRISMStateSpaceExporter
implements StateSpaceExporter {
    public void export(StateSpace stateSpace, URI uri, IProgressMonitor monitor) throws IOException {
        monitor.beginTask("Exporting state space...", stateSpace.getTransitionCount());
        File file = new File(uri.toFileString());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 65536);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer.write("// CTMC model generated by Henshin on " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "\n\n");
        writer.write("ctmc\n\n");
        for (Rule rule : stateSpace.getRules()) {
            writer.write("const double " + RatesPropertiesManager.getRateKey(rule) + ";\n");
        }
        writer.write("\nmodule Transformation\n\n");
        writer.write("\ts : [0.." + stateSpace.getStates().size() + "];\n\n");
        block1: for (State s : stateSpace.getStates()) {
            for (Transition t : s.getOutgoing()) {
                writer.write("\t[" + PRISMStateSpaceExporter.getAction(t.getRule()) + "] s=" + s.getIndex() + " -> " + RatesPropertiesManager.getRateKey(t.getRule()) + " : (s'=" + t.getTarget().getIndex() + ");\n");
                monitor.worked(1);
                if (monitor.isCanceled()) continue block1;
            }
        }
        writer.write("\nendmodule\n\n");
        writer.write("init\n\t");
        int i = 0;
        while (i < stateSpace.getInitialStates().size()) {
            writer.write("s=" + ((State)stateSpace.getInitialStates().get(i)).getIndex());
            if (i < stateSpace.getInitialStates().size() - 1) {
                writer.write(" | ");
            }
            ++i;
        }
        writer.write("\nendinit\n");
        writer.close();
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    protected static String getAction(Rule rule) {
        return rule.getName().trim();
    }

    public String getName() {
        return "PRISM";
    }

    public String[] getFileExtensions() {
        return new String[]{"sm"};
    }
}

