/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class HenshinRuleAnalysisUtil {
    public static boolean isAddingNodes(Rule rule) {
        for (Node node : rule.getRhs().getNodes()) {
            if (HenshinMappingUtil.getNodeOrigin(node, rule.getMappings()) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeletingNodes(Rule rule) {
        for (Node node : rule.getLhs().getNodes()) {
            if (HenshinMappingUtil.getNodeImage(node, rule.getRhs(), rule.getMappings()) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAddingEdges(Rule rule) {
        for (Edge edge : rule.getRhs().getEdges()) {
            if (HenshinMappingUtil.getEdgeOrigin(edge, rule.getMappings()) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeletingEdges(Rule rule) {
        for (Edge edge : rule.getLhs().getEdges()) {
            if (HenshinMappingUtil.getEdgeImage(edge, rule.getRhs(), rule.getMappings()) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeletionEdge(Edge edge) {
        if (edge.getSource() != null && edge.getTarget() != null && edge.getGraph() != null && edge.getGraph().getContainerRule() != null) {
            Rule rule = edge.getGraph().getContainerRule();
            return HenshinRuleAnalysisUtil.isLHS(edge.getGraph()) && HenshinMappingUtil.getEdgeImage(edge, rule.getRhs(), rule.getMappings()) == null;
        }
        return false;
    }

    public static boolean isCreationEdge(Edge edge) {
        if (edge.getSource() != null && edge.getTarget() != null && edge.getGraph() != null && edge.getGraph().getContainerRule() != null) {
            Rule rule = edge.getGraph().getContainerRule();
            return HenshinRuleAnalysisUtil.isRHS(edge.getGraph()) && HenshinMappingUtil.getEdgeOrigin(edge, rule.getMappings()) == null;
        }
        return false;
    }

    public static boolean isChangingAttributes(Rule rule) {
        for (Node node : rule.getRhs().getNodes()) {
            for (Attribute attribute : node.getAttributes()) {
                Attribute origin = HenshinMappingUtil.getAttributeOrigin(attribute, rule.getMappings());
                if (origin != null && HenshinRuleAnalysisUtil.valueEquals(attribute.getValue(), origin.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean valueEquals(String v1, String v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.trim().equals(v2.trim());
    }

    public static boolean isChanging(Rule rule) {
        return HenshinRuleAnalysisUtil.isAddingNodes(rule) || HenshinRuleAnalysisUtil.isDeletingNodes(rule) || HenshinRuleAnalysisUtil.isAddingEdges(rule) || HenshinRuleAnalysisUtil.isDeletingEdges(rule) || HenshinRuleAnalysisUtil.isChangingAttributes(rule);
    }

    public static boolean isLHS(Graph graph) {
        return graph.eContainer() != null && graph.eContainer() instanceof Rule && graph.getContainerRule().getLhs() == graph;
    }

    public static boolean isLHSPart(Graph graph) {
        boolean result = true;
        Graph eobject = graph;
        while (eobject.eContainer() != null && !(eobject.eContainer() instanceof Rule)) {
            eobject = eobject.eContainer();
        }
        if (eobject instanceof Graph) {
            result = HenshinRuleAnalysisUtil.isLHS(eobject);
        }
        return result;
    }

    public static boolean isRHS(Graph graph) {
        return graph.eContainer() != null && graph.eContainer() instanceof Rule && graph.getContainerRule().getRhs() == graph;
    }

    public static boolean isConclusion(Graph graph) {
        return graph.eContainer() != null && graph.eContainer() instanceof NestedCondition;
    }
}

