/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapterFactory;
import org.eclipse.emf.henshin.provider.filter.BaseFilterProvider;

public class FilteringItemProviderAdapter
extends ItemProviderAdapter {
    protected boolean filteringEnabled = false;
    protected BaseFilterProvider filterProvider = null;

    public FilteringItemProviderAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
        if (adapterFactory instanceof HenshinItemProviderAdapterFactory) {
            this.filterProvider = ((HenshinItemProviderAdapterFactory)adapterFactory).getFeatureFilterProvider();
            this.filteringEnabled = this.filterProvider != null;
        }
    }

    protected Collection<? extends EStructuralFeature> getAnyChildrenFeatures(Object object) {
        Collection<? extends EStructuralFeature> result = this.getChildrenFeatures(object);
        if (this.filteringEnabled && !this.isWrappingNeeded(object)) {
            result = this.filterProvider.filterChildFeatures(result);
        }
        return result.isEmpty() ? this.getChildrenReferences(object) : result;
    }

    protected ItemProviderAdapter.ChildrenStore getChildrenStore(Object object) {
        ItemProviderAdapter.ChildrenStore store = super.getChildrenStore(object);
        return store;
    }

    public Collection<?> getChildren(Object object) {
        ItemProviderAdapter.ChildrenStore store = this.getChildrenStore(object);
        if (store != null) {
            return store.getChildren();
        }
        store = this.createChildrenStore(object);
        ArrayList<Object> result = store != null ? null : new ArrayList<Object>();
        EObject eObject = (EObject)object;
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            if (eStructuralFeature.isMany()) {
                List children = (List)eObject.eGet(eStructuralFeature);
                int index = 0;
                for (Object unwrappedChild : children) {
                    Object child = this.wrap(eObject, eStructuralFeature, unwrappedChild, index);
                    if (store != null) {
                        store.getList(eStructuralFeature).add(child);
                    } else {
                        result.add(child);
                    }
                    ++index;
                }
                continue;
            }
            Object child = eObject.eGet(eStructuralFeature);
            if (child == null) continue;
            child = this.wrap(eObject, eStructuralFeature, child, -1);
            if (store != null) {
                store.setValue(eStructuralFeature, child);
                continue;
            }
            result.add(child);
        }
        return store != null ? store.getChildren() : result;
    }

    protected boolean hasChildren(Object object, boolean optimized) {
        if (!optimized) {
            return !this.getChildren(object).isEmpty();
        }
        EObject eObject = (EObject)object;
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            List children;
            if (!(eStructuralFeature.isMany() ? !(children = (List)eObject.eGet(eStructuralFeature)).isEmpty() : eObject.eGet(eStructuralFeature, false) != null)) continue;
            return true;
        }
        return false;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        EReference oldFeature = this.getChildReference(object, child);
        if (oldFeature != null) {
            return oldFeature;
        }
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        EObject eObject = (EObject)object;
        ArrayList newChildDescriptors = new ArrayList();
        this.collectNewChildDescriptors(newChildDescriptors, object);
        if (this.adapterFactory instanceof IChildCreationExtender) {
            newChildDescriptors.addAll(((IChildCreationExtender)this.adapterFactory).getNewChildDescriptors(object, editingDomain));
        }
        if (sibling != null) {
            sibling = this.unwrap(sibling);
            Collection<? extends EStructuralFeature> childrenFeatures = this.getAnyChildrenFeatures(object);
            int siblingFeatureIndex = -1;
            int i = 0;
            block0: for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                Object featureValue = eObject.eGet(eStructuralFeature);
                if (eStructuralFeature.isMany()) {
                    for (Object value : (Collection)featureValue) {
                        if (!this.isEquivalentValue(sibling, value)) continue;
                        siblingFeatureIndex = i;
                        break block0;
                    }
                } else if (this.isEquivalentValue(sibling, featureValue)) {
                    siblingFeatureIndex = i;
                    break;
                }
                ++i;
            }
            block2: for (Object object2 : newChildDescriptors) {
                CommandParameter parameter;
                EStructuralFeature childFeature;
                if (!(object2 instanceof CommandParameter) || (childFeature = (parameter = (CommandParameter)object2).getEStructuralFeature()) == null || !childFeature.isMany()) continue;
                i = 0;
                for (Object e : (Collection)eObject.eGet(childFeature)) {
                    if (this.isEquivalentValue(sibling, e)) {
                        parameter.index = i + 1;
                        continue block2;
                    }
                    ++i;
                }
                if (siblingFeatureIndex == -1) continue;
                i = 0;
                for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                    if (eStructuralFeature == childFeature) {
                        if (i <= siblingFeatureIndex) continue block2;
                        parameter.index = 0;
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        return newChildDescriptors;
    }

    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        CompoundCommand removeCommand = new CompoundCommand(Integer.MAX_VALUE);
        block0: for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(eObject)) {
            Object value;
            if (eStructuralFeature.isMany()) {
                value = (List)this.getFeatureValue(eObject, eStructuralFeature);
                ArrayList childrenOfThisFeature = new ArrayList();
                ListIterator objects = list.listIterator();
                while (objects.hasNext()) {
                    Object o = objects.next();
                    if (!value.contains(o)) continue;
                    childrenOfThisFeature.add(o);
                    objects.remove();
                }
                if (childrenOfThisFeature.isEmpty()) continue;
                removeCommand.append(this.createRemoveCommand(domain, eObject, eStructuralFeature, childrenOfThisFeature));
                continue;
            }
            value = this.getFeatureValue(eObject, eStructuralFeature);
            ListIterator objects = list.listIterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                if (o != value) continue;
                Command setCommand = this.createSetCommand(domain, eObject, eStructuralFeature, SetCommand.UNSET_VALUE);
                removeCommand.append((Command)new CommandWrapper(setCommand){
                    protected Collection<?> affected;

                    public void execute() {
                        super.execute();
                        this.affected = Collections.singleton(eObject);
                    }

                    public void undo() {
                        super.undo();
                        this.affected = Collections.singleton(value);
                    }

                    public void redo() {
                        super.redo();
                        this.affected = Collections.singleton(eObject);
                    }

                    public Collection<?> getResult() {
                        return Collections.singleton(value);
                    }

                    public Collection<?> getAffectedObjects() {
                        return this.affected;
                    }
                });
                objects.remove();
                continue block0;
            }
        }
        if (list.isEmpty()) {
            return removeCommand.unwrap();
        }
        removeCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        int index = commandParameter.getIndex();
        CompoundCommand addCommand = new CompoundCommand(Integer.MAX_VALUE);
        while (!list.isEmpty()) {
            ListIterator children = list.listIterator();
            final Object firstChild = children.next();
            EStructuralFeature childFeature = this.getChildFeature(eObject, firstChild);
            if (childFeature == null) break;
            if (childFeature.isMany()) {
                if (index != -1) {
                    for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(eObject)) {
                        if (eStructuralFeature == childFeature) break;
                        if (eStructuralFeature.isMany()) {
                            index -= ((List)eObject.eGet(eStructuralFeature)).size();
                            continue;
                        }
                        if (eObject.eGet(eStructuralFeature) == null) continue;
                        --index;
                    }
                    if (index < 0) break;
                }
                ArrayList arrayList = new ArrayList();
                arrayList.add(firstChild);
                children.remove();
                while (children.hasNext()) {
                    Object child = children.next();
                    if (this.getChildFeature(eObject, child) != childFeature) continue;
                    arrayList.add(child);
                    children.remove();
                }
                addCommand.append(this.createAddCommand(domain, eObject, childFeature, arrayList, index));
                if (index >= arrayList.size()) {
                    index -= arrayList.size();
                    continue;
                }
                index = -1;
                continue;
            }
            if (eObject.eGet(childFeature) != null) break;
            Command command = this.createSetCommand(domain, eObject, childFeature, firstChild);
            addCommand.append((Command)new CommandWrapper(command){
                protected Collection<?> affected;

                public void execute() {
                    super.execute();
                    this.affected = Collections.singleton(firstChild);
                }

                public void undo() {
                    super.undo();
                    this.affected = Collections.singleton(eObject);
                }

                public void redo() {
                    super.redo();
                    this.affected = Collections.singleton(firstChild);
                }

                public Collection<?> getResult() {
                    return Collections.singleton(firstChild);
                }

                public Collection<?> getAffectedObjects() {
                    return this.affected;
                }
            });
            children.remove();
        }
        if (list.isEmpty()) {
            return addCommand.unwrap();
        }
        addCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected Command factorMoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        EObject eObject = commandParameter.getEOwner();
        Object value = commandParameter.getValue();
        int index = commandParameter.getIndex();
        EStructuralFeature childFeature = this.getChildFeature(eObject, value);
        if (childFeature != null && childFeature.isMany()) {
            for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(eObject)) {
                if (eStructuralFeature == childFeature) break;
                if (eStructuralFeature.isMany()) {
                    index -= ((List)eObject.eGet(eStructuralFeature)).size();
                    continue;
                }
                if (eObject.eGet(eStructuralFeature) == null) continue;
                --index;
            }
            return this.createMoveCommand(domain, eObject, childFeature, value, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isWrappingNeeded(Object object) {
        if (this.wrappingNeeded == null) {
            this.wrappingNeeded = Boolean.FALSE;
            for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                this.wrappingNeeded = Boolean.TRUE;
            }
        }
        return this.wrappingNeeded;
    }

    protected ItemProviderAdapter.ChildrenStore createChildrenStore(Object object) {
        FilteringChildrenStore store = null;
        if (this.isWrappingNeeded(object)) {
            if (this.childrenStoreMap == null) {
                this.childrenStoreMap = new HashMap();
            }
            store = new FilteringChildrenStore(this.getAnyChildrenFeatures(object), this.filterProvider);
            this.childrenStoreMap.put(object, store);
        }
        return store;
    }

    protected static class FilteringChildrenStore
    extends ItemProviderAdapter.ChildrenStore {
        protected BaseFilterProvider filterProvider;

        public FilteringChildrenStore(Collection<? extends EStructuralFeature> childrenFeatures, BaseFilterProvider filterProvider) {
            super(childrenFeatures);
            this.filterProvider = filterProvider;
        }

        public Object get(EStructuralFeature feature, int index) {
            System.out.println("simple get");
            return super.get(feature, index);
        }

        public List<Object> getChildren() {
            int size = 0;
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i].list != null && !this.filterProvider.isFiltered(this.entries[i].feature.getEType())) {
                    size += this.entries[i].feature.isMany() ? this.entries[i].list.size() : (this.entries[i].list.get(0) != null ? 1 : 0);
                }
                ++i;
            }
            ArrayList<Object> result = new ArrayList<Object>(size);
            int i2 = 0;
            while (i2 < this.entries.length) {
                if (this.entries[i2].list != null && !this.filterProvider.isFiltered(this.entries[i2].feature.getEType())) {
                    if (this.entries[i2].feature.isMany()) {
                        result.addAll((Collection<Object>)this.entries[i2].list);
                    } else if (this.entries[i2].list.get(0) != null) {
                        result.add(this.entries[i2].list.get(0));
                    }
                }
                ++i2;
            }
            return result;
        }
    }
}

