/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.EClassComparator;
import org.eclipse.emf.henshin.diagram.part.HenshinPaletteTools;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;

public class HenshinPaletteUpdater {
    private static final Comparator<EClassifier> ECLASS_COMPARATOR = new EClassComparator();
    private PaletteRoot palette;
    private Module module;
    private HashMap<EPackage, PaletteDrawer> drawers;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            int featureID = event.getFeatureID(Module.class);
            if (featureID == 4) {
                HenshinPaletteUpdater.this.refresh();
            }
        }
    };

    public HenshinPaletteUpdater(PaletteRoot palette, Module module) {
        this.palette = palette;
        this.module = module;
        this.drawers = new HashMap();
        module.eAdapters().add((Object)this.listener);
        this.refresh();
    }

    public void refresh() {
        for (PaletteDrawer drawer : this.drawers.values()) {
            this.palette.remove((PaletteEntry)drawer);
        }
        this.drawers.clear();
        for (EPackage epackage : this.module.getImports()) {
            this.addDrawerForEPackageHelper(epackage, "");
        }
    }

    private void addDrawerForEPackageHelper(EPackage epackage, String prefix) {
        String epackageName = String.valueOf(prefix) + epackage.getName();
        PaletteDrawer drawer = new PaletteDrawer(epackageName, HenshinPaletteTools.EPACKAGE_ICON);
        ArrayList eclassifiers = new ArrayList(epackage.getEClassifiers());
        Collections.sort(eclassifiers, ECLASS_COMPARATOR);
        for (EClassifier eclassifier : eclassifiers) {
            if (!(eclassifier instanceof EClass)) continue;
            drawer.add((PaletteEntry)new HenshinPaletteTools.EClassNodeToolEntry((EClass)eclassifier));
        }
        this.palette.add((PaletteEntry)drawer);
        this.drawers.put(epackage, drawer);
        for (EPackage ep : epackage.getESubpackages()) {
            this.addDrawerForEPackageHelper(ep, String.valueOf(epackageName) + ".");
        }
    }

    public void dispose() {
        this.module.eAdapters().remove((Object)this.listener);
    }
}

