/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.rulegen.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class RadioButtonSelectionDialog
extends SelectionDialog {
    private List<Map.Entry<String, String>> buttonList;
    private List<Button> widgetButtonList;

    public RadioButtonSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout containerLayout = new GridLayout(1, true);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)containerLayout);
        GridData labelGridData = new GridData(4, 4, true, false);
        Label label = super.createMessageArea(container);
        label.setLayoutData((Object)labelGridData);
        this.widgetButtonList = new ArrayList<Button>();
        GridData buttonGroupGridData = new GridData(4, 4, true, false);
        Group buttonGroup = new Group(container, 0);
        buttonGroup.setText("Selected Resources");
        buttonGroup.setLayout((Layout)new GridLayout(1, true));
        buttonGroup.setLayoutData((Object)buttonGroupGridData);
        boolean firstButtonSet = false;
        for (Map.Entry<String, String> usrbutton : this.buttonList) {
            Button tmpButton = new Button((Composite)buttonGroup, 16);
            tmpButton.setText(usrbutton.getValue());
            if (!firstButtonSet) {
                tmpButton.setSelection(true);
                firstButtonSet = true;
            }
            this.widgetButtonList.add(tmpButton);
        }
        return container;
    }

    protected void saveInput() {
        int i = 0;
        while (i < this.widgetButtonList.size()) {
            if (this.widgetButtonList.get(i).getSelection()) {
                ArrayList<String> result = new ArrayList<String>();
                result.add(this.buttonList.get(i).getKey());
                super.setResult(result);
            }
            ++i;
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public void setButtonList(List<Map.Entry<String, String>> buttons) {
        this.buttonList = buttons;
    }

    public List<Map.Entry<String, String>> getButtonList() {
        return this.buttonList;
    }
}

