/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.rulegen.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.rulegen.matching.Correspondence;

public class Matching {
    private Map<EObject, EObject> correspondencesA2B = new HashMap<EObject, EObject>();
    private Map<EObject, EObject> correspondencesB2A = new HashMap<EObject, EObject>();
    private List<Correspondence> correspondences = new ArrayList<Correspondence>();

    public void addCorrespondence(EObject elementA, EObject elementB) {
        if (!this.correspondencesA2B.containsKey(elementA) && !this.correspondencesB2A.containsKey(elementB)) {
            this.correspondencesA2B.put(elementA, elementB);
            this.correspondencesB2A.put(elementB, elementA);
            this.correspondences.add(new Correspondence(elementA, elementB));
        }
    }

    public List<Correspondence> getCorrespondences() {
        return this.correspondences;
    }

    public boolean isMatched(EObject obj) {
        return this.correspondencesA2B.containsKey(obj) || this.correspondencesB2A.containsKey(obj);
    }

    public EObject getCorresponding(EObject obj) {
        if (this.correspondencesA2B.containsKey(obj)) {
            return this.correspondencesA2B.get(obj);
        }
        if (this.correspondencesB2A.containsKey(obj)) {
            return this.correspondencesB2A.get(obj);
        }
        return null;
    }

    public String toString() {
        String res = String.valueOf(super.toString()) + "\n";
        Iterator<EObject> iterator = this.correspondencesA2B.keySet().iterator();
        while (iterator.hasNext()) {
            EObject objA = iterator.next();
            EObject objB = this.correspondencesA2B.get(objA);
            res = String.valueOf(res) + " " + objA + " <-> " + objB;
            if (!iterator.hasNext()) continue;
            res = String.valueOf(res) + "\n";
        }
        return res;
    }
}

