/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.editor.commands.CopySubGraphToNestedConditionsCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.editor.commands.WrapFormulaInJunctionCommand;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class CreateNestedConditionMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new CreateNestedConditionMenuContributor();
    private static final String COMMAND_LABEL = "CopySubGraphToNestedConditions";
    private static final String COMMAND_LABEL_SUBMENU = "CopySubGraphToNestedConditions_Submenu";
    private static final String COMMAND_LABEL_REPLACE = "CopySubGraphToNestedConditions_ReplaceCurrent";

    @Override
    protected void contributeActions(IMenuManager menuManager, List<?> selection) {
        if (selection.size() > 0 && QuantUtil.allInstancesOf(Node.class, selection.toArray())) {
            Graph graph = null;
            boolean initialized = false;
            boolean applicable = true;
            Iterator<Node> iterator = selection.iterator();
            while (iterator.hasNext()) {
                Node node;
                Node node2 = node = iterator.next();
                if (!initialized) {
                    graph = node2.getGraph();
                    initialized = true;
                }
                if (graph != null && node2.getGraph() == graph) continue;
                applicable = false;
                break;
            }
            if (applicable) {
                if (graph.getFormula() == null) {
                    menuManager.add(this.createAction(this.getLabel(COMMAND_LABEL), (Command)new CopySubGraphToNestedConditionsCommand(this.domain, selection)));
                } else {
                    MenuManager menuManager2 = new MenuManager(this.getLabel(COMMAND_LABEL_SUBMENU));
                    menuManager2.add(this.createAction(this.getLabel(COMMAND_LABEL_REPLACE), (Command)new CopySubGraphToNestedConditionsCommand(this.domain, selection)));
                    final WrapFormulaInJunctionCommand wrapCmd = WrapFormulaInJunctionCommand.createWrapInAndCommand(graph.getFormula());
                    final CopySubGraphToNestedConditionsCommand copycmd = new CopySubGraphToNestedConditionsCommand(this.domain, selection);
                    CompoundCommand cmd = new CompoundCommand(){

                        public boolean canExecute() {
                            return true;
                        }

                        public void execute() {
                            this.appendAndExecute((Command)wrapCmd);
                            Object[] aObj = wrapCmd.getAffectedObjects().toArray();
                            if (aObj.length < 1 || !(aObj[0] instanceof BinaryFormula)) {
                                this.appendAndExecute((Command)UnexecutableCommand.INSTANCE);
                                return;
                            }
                            BinaryFormula wrapFormula = (BinaryFormula)aObj[0];
                            copycmd.setOwner((EObject)wrapFormula);
                            copycmd.setFeature(wrapFormula.eClass().getEStructuralFeature(2));
                            this.appendAndExecute((Command)copycmd);
                        }
                    };
                    menuManager2.add(this.createAction(this.getLabel("CopySubGraphToNestedConditions_WrapWithCurrent"), (Command)cmd));
                    menuManager.add((IContributionItem)menuManager2);
                }
            }
        }
    }
}

