/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.gui.icons.CompletionIcon;
import agg.gui.options.AbstractOptionGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.trafo.GraGraTransform;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.csp.CompletionPropertyBits;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class GraTraMatchOptionGUI
extends AbstractOptionGUI {
    GraGraTransform transform;
    MorphCompletionStrategy strategy;
    JComboBox strategyComboBox;
    JCheckBox injCB;
    JCheckBox identCB;
    JCheckBox dangCB;
    JCheckBox checkRuleApplCB;
    JCheckBox parallelMatchingCB;
    JCheckBox selectMatchCB;
    JCheckBox showGraphAfterStepCB;
    JCheckBox waitAfterStepCB;
    JCheckBox selectNewAfterStepCB;
    JCheckBox consistencyCheckAfterGraphTrafoCB;
    JCheckBox randomCSPDomain;
    JRadioButton consistencyRB1;
    JRadioButton consistencyRB2;
    Vector<String> strategyNames = new Vector(3);
    Vector<String> bitNames = new Vector(3);
    String bitName = "";
    Vector<JCheckBox> checkboxBitNames = new Vector(3);
    BitSet supportbits;
    BitSet activebits;
    JPanel mainPanel;
    boolean consistency;
    boolean showGraphAfterStep;
    boolean waitAfterStep;
    boolean selectMatch;
    boolean selectNewAfterStep;
    boolean checkRuleAppl;
    boolean parallelMatching;
    boolean consistencyCheckAfterGraphTrafo;

    public GraTraMatchOptionGUI(GraGraTransform trans) {
        this.transform = trans;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        JPanel stratPanel = new JPanel();
        stratPanel.setLayout(new GridLayout(0, 1));
        JLabel stratLabel = new JLabel("Match completion strategy");
        CompletionIcon icon = new CompletionIcon(Color.black);
        icon.setEnabled(true);
        stratLabel.setIcon(icon);
        stratPanel.add(stratLabel);
        Enumeration<MorphCompletionStrategy> strategies = CompletionStrategySelector.getStrategies();
        while (strategies.hasMoreElements()) {
            MorphCompletionStrategy mcs = strategies.nextElement();
            this.strategyNames.addElement(CompletionStrategySelector.getName(mcs));
        }
        if (this.strategy == null) {
            this.strategy = CompletionStrategySelector.getDefault();
        }
        this.strategyComboBox = new JComboBox<String>(this.strategyNames);
        this.strategyComboBox.setSelectedItem(CompletionStrategySelector.getName(this.strategy));
        this.strategyComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String stratName = (String)e.getItem();
                    Enumeration<MorphCompletionStrategy> strats = CompletionStrategySelector.getStrategies();
                    while (strats.hasMoreElements()) {
                        MorphCompletionStrategy mcs = strats.nextElement();
                        String name = CompletionStrategySelector.getName(mcs);
                        if (!stratName.equals(name)) continue;
                        GraTraMatchOptionGUI.this.strategy = mcs;
                        GraTraMatchOptionGUI.this.setStrategyProperties(GraTraMatchOptionGUI.this.strategy);
                        GraTraMatchOptionGUI.this.transform.setCompletionStrategy(GraTraMatchOptionGUI.this.strategy);
                    }
                }
            }
        });
        stratPanel.add(this.strategyComboBox);
        JPanel matchPanel = new JPanel(new BorderLayout());
        matchPanel.setBorder(new TitledBorder("  Match conditions  "));
        JPanel matchP = new JPanel(new GridLayout(1, 0));
        JPanel matchP1 = new JPanel(new GridLayout(0, 1));
        JPanel matchP2 = new JPanel(new GridLayout(0, 1));
        matchP.add(matchP1);
        matchP.add(matchP2);
        this.supportbits = this.strategy.getSupportedProperties();
        this.activebits = this.strategy.getProperties();
        int i = 0;
        while (i < CompletionPropertyBits.BITNAME.length) {
            this.bitName = CompletionPropertyBits.BITNAME[i];
            this.bitNames.addElement(this.bitName);
            JCheckBox cb = new JCheckBox(this.bitName, null, true);
            if (cb.getText().equals("injective")) {
                this.injCB = cb;
                matchP1.add(cb);
            } else if (cb.getText().equals("dangling")) {
                this.dangCB = cb;
                matchP1.add(cb);
            } else if (cb.getText().equals("identification")) {
                this.identCB = cb;
                matchP1.add(cb);
            } else if (cb.getText().equals("NACs")) {
                cb.setToolTipText("Negative Application Conditions");
                matchP2.add(cb);
            } else if (cb.getText().equals("PACs")) {
                cb.setToolTipText("Positive Application Conditions");
                matchP2.add(cb);
            } else if (cb.getText().equals("GACs")) {
                cb.setToolTipText("General Application Conditions");
                matchP2.add(cb);
            }
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int j = 0;
                    while (j < GraTraMatchOptionGUI.this.checkboxBitNames.size()) {
                        JCheckBox elem = GraTraMatchOptionGUI.this.checkboxBitNames.elementAt(j);
                        if (e.getSource() == elem) {
                            if (elem.isSelected()) {
                                GraTraMatchOptionGUI.this.activebits.set(j);
                                if (elem == GraTraMatchOptionGUI.this.injCB) {
                                    GraTraMatchOptionGUI.this.identCB.setEnabled(false);
                                }
                            } else {
                                GraTraMatchOptionGUI.this.activebits.clear(j);
                                if (elem == GraTraMatchOptionGUI.this.injCB) {
                                    GraTraMatchOptionGUI.this.identCB.setEnabled(true);
                                }
                            }
                            GraTraMatchOptionGUI.this.transform.updateGraTraOption(elem.getText(), elem.isSelected());
                        }
                        GraTraMatchOptionGUI.this.fireOptionEvent(new OptionEvent(elem));
                        ++j;
                    }
                }
            });
            this.checkboxBitNames.addElement(cb);
            this.checkboxBitNames.lastElement().setEnabled(this.supportbits.get(i));
            this.checkboxBitNames.lastElement().setSelected(this.activebits.get(i));
            ++i;
        }
        JPanel matchP3 = new JPanel(new GridLayout(0, 1));
        matchP3.add(new JLabel(" ---------------------------"));
        this.randomCSPDomain = new JCheckBox("Randomized CSP search domain", null, true);
        this.randomCSPDomain.setSelected(this.strategy.isRandomisedDomain());
        this.randomCSPDomain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.strategy.setRandomisedDomain(GraTraMatchOptionGUI.this.randomCSPDomain.isSelected());
                GraTraMatchOptionGUI.this.transform.updateGraTraOption("determinedCSPDomain", !GraTraMatchOptionGUI.this.randomCSPDomain.isSelected());
            }
        });
        matchP3.add(this.randomCSPDomain);
        matchPanel.add((Component)matchP, "Center");
        matchPanel.add((Component)matchP3, "South");
        JPanel consistencyPanel = new JPanel();
        consistencyPanel.setBorder(new TitledBorder("  Consistency check during transformation  "));
        consistencyPanel.setLayout(new GridLayout(0, 1));
        ButtonGroup group = new ButtonGroup();
        this.consistencyRB1 = new JRadioButton("consistent transformations only");
        group.add(this.consistencyRB1);
        consistencyPanel.add(this.consistencyRB1);
        this.consistencyRB1.setActionCommand("consistentOnly");
        this.consistencyRB1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraMatchOptionGUI.this.consistencyRB1.isSelected()) {
                    GraTraMatchOptionGUI.this.consistency = true;
                    GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafoCB.setSelected(false);
                    GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo = false;
                }
                GraTraMatchOptionGUI.this.transform.updateGraTraOption("consistency", GraTraMatchOptionGUI.this.consistency);
            }
        });
        this.consistencyRB2 = new JRadioButton("stop after inconsistent transformation");
        group.add(this.consistencyRB2);
        consistencyPanel.add(this.consistencyRB2);
        this.consistencyRB2.setActionCommand("inconsistentStop");
        this.consistencyRB2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraMatchOptionGUI.this.consistencyRB2.isSelected()) {
                    GraTraMatchOptionGUI.this.consistency = false;
                    GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafoCB.setSelected(false);
                    GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo = false;
                }
                GraTraMatchOptionGUI.this.transform.updateGraTraOption("consistency", GraTraMatchOptionGUI.this.consistency);
            }
        });
        consistencyPanel.add(new JLabel(" Consistency check at the end of ( layer ) graph trafo"));
        this.consistencyCheckAfterGraphTrafoCB = new JCheckBox("consistent at the end", null, false);
        consistencyPanel.add(this.consistencyCheckAfterGraphTrafoCB);
        this.consistencyCheckAfterGraphTrafo = false;
        this.consistencyCheckAfterGraphTrafoCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo = GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafoCB.isSelected();
                GraTraMatchOptionGUI.this.consistencyRB1.setEnabled(!GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo);
                GraTraMatchOptionGUI.this.consistencyRB2.setEnabled(!GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo);
                GraTraMatchOptionGUI.this.transform.updateGraTraOption("consistencyCheckAfterGraphTrafo", GraTraMatchOptionGUI.this.consistencyCheckAfterGraphTrafo);
            }
        });
        JPanel ruleApplPanel = new JPanel();
        ruleApplPanel.setBorder(new TitledBorder("  Rule applicability on the host graph  "));
        ruleApplPanel.setLayout(new GridLayout(0, 1));
        this.checkRuleApplCB = new JCheckBox("check", null, false);
        ruleApplPanel.add(this.checkRuleApplCB);
        this.checkRuleAppl = false;
        this.checkRuleApplCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.checkRuleAppl = GraTraMatchOptionGUI.this.checkRuleApplCB.isSelected();
                GraTraMatchOptionGUI.this.transform.updateGraTraOption("checkRuleApplicability", GraTraMatchOptionGUI.this.checkRuleAppl);
            }
        });
        JPanel displayPanel = new JPanel(new GridLayout(0, 1));
        displayPanel.setBorder(new TitledBorder("  Graph display settings  "));
        this.selectMatchCB = new JCheckBox("select objects of match", null, false);
        displayPanel.add(this.selectMatchCB);
        this.selectMatch = false;
        this.selectMatchCB.setActionCommand("selectMatch");
        this.selectMatchCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.selectMatch = GraTraMatchOptionGUI.this.selectMatchCB.isSelected();
            }
        });
        this.showGraphAfterStepCB = new JCheckBox("show after step", null, true);
        displayPanel.add(this.showGraphAfterStepCB);
        this.showGraphAfterStep = true;
        this.showGraphAfterStepCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.showGraphAfterStep = GraTraMatchOptionGUI.this.showGraphAfterStepCB.isSelected();
            }
        });
        this.waitAfterStepCB = new JCheckBox("wait after step", null, false);
        displayPanel.add(this.waitAfterStepCB);
        this.waitAfterStepCB.setActionCommand("waitAfterStep");
        this.waitAfterStep = false;
        this.waitAfterStepCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.waitAfterStep = GraTraMatchOptionGUI.this.waitAfterStepCB.isSelected();
            }
        });
        this.selectNewAfterStepCB = new JCheckBox("select new objects after step", null, false);
        displayPanel.add(this.selectNewAfterStepCB);
        this.selectNewAfterStep = false;
        this.selectNewAfterStepCB.setActionCommand("selectNewAfterStep");
        this.selectNewAfterStepCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraMatchOptionGUI.this.selectNewAfterStep = GraTraMatchOptionGUI.this.selectNewAfterStepCB.isSelected();
            }
        });
        this.constrainBuild(this, stratPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, matchPanel, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, consistencyPanel, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, ruleApplPanel, 0, 3, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, displayPanel, 0, 4, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 690);
    }

    @Override
    public String getTabTitle() {
        return "General";
    }

    @Override
    public String getTabTip() {
        return "General Transformation Options";
    }

    @Override
    public void update() {
        this.update(this.transform.getGraTraOptionsList());
    }

    public void update(Vector<String> optionNames) {
        if (optionNames.isEmpty()) {
            return;
        }
        if (optionNames.contains("CSP")) {
            this.strategyComboBox.setSelectedItem("CSP");
        } else if (optionNames.contains("CSP w/o BJ")) {
            this.strategyComboBox.setSelectedItem("CSP w/o BJ");
        }
        String stratName = (String)this.strategyComboBox.getSelectedItem();
        Enumeration<MorphCompletionStrategy> strats = CompletionStrategySelector.getStrategies();
        while (strats.hasMoreElements()) {
            MorphCompletionStrategy mcs = strats.nextElement();
            String name = CompletionStrategySelector.getName(mcs);
            if (!stratName.equals(name)) continue;
            this.strategy = mcs;
            break;
        }
        if (this.strategy == null) {
            this.strategy = CompletionStrategySelector.getDefault();
        }
        this.supportbits = this.strategy.getSupportedProperties();
        this.activebits = this.strategy.getProperties();
        int j = 0;
        while (j < this.checkboxBitNames.size()) {
            JCheckBox elem = this.checkboxBitNames.elementAt(j);
            elem.setEnabled(this.supportbits.get(j));
            if (elem.isEnabled()) {
                if (elem.getText().equals("injective")) {
                    if (optionNames.contains("injective")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                } else if (elem.getText().equals("dangling")) {
                    if (optionNames.contains("dangling")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                } else if (elem.getText().equals("identification")) {
                    if (optionNames.contains("identification")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                } else if (elem.getText().equals("NACs")) {
                    if (optionNames.contains("NACs")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                } else if (elem.getText().equals("PACs")) {
                    if (optionNames.contains("PACs")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                } else if (elem.getText().equals("GACs")) {
                    if (optionNames.contains("GACs")) {
                        elem.setSelected(true);
                        this.activebits.set(j);
                    } else {
                        elem.setSelected(false);
                        this.activebits.clear(j);
                    }
                }
                this.fireOptionEvent(new OptionEvent(elem));
            }
            ++j;
        }
        if (this.injCB.isSelected()) {
            this.identCB.setEnabled(false);
        } else {
            this.identCB.setEnabled(true);
        }
        if (optionNames.contains("determinedCSPDomain")) {
            this.randomCSPDomain.setSelected(false);
            this.strategy.setRandomisedDomain(false);
        } else {
            this.randomCSPDomain.setSelected(true);
            this.strategy.setRandomisedDomain(true);
        }
        if (optionNames.contains("consistency")) {
            this.consistencyRB1.setSelected(true);
            this.consistency = true;
        } else {
            this.consistencyRB2.setSelected(true);
            this.consistency = false;
        }
        if (optionNames.contains("consistencyCheckAfterGraphTrafo")) {
            this.consistencyCheckAfterGraphTrafoCB.setSelected(true);
            this.consistencyCheckAfterGraphTrafo = true;
            this.consistencyRB1.setEnabled(false);
            this.consistencyRB2.setEnabled(false);
        } else {
            this.consistencyCheckAfterGraphTrafoCB.setSelected(false);
            this.consistencyCheckAfterGraphTrafo = false;
            this.consistencyRB1.setEnabled(true);
            this.consistencyRB2.setEnabled(true);
        }
        if (optionNames.contains("selectNewAfterStep")) {
            this.selectNewAfterStep = true;
            this.selectNewAfterStepCB.setSelected(true);
        }
        if (optionNames.contains("waitAfterStep")) {
            this.waitAfterStep = true;
            this.waitAfterStepCB.setSelected(true);
        }
    }

    public MorphCompletionStrategy getMorphCompletionStrategy() {
        return this.strategy;
    }

    public boolean consistencyEnabled() {
        return this.consistency;
    }

    public boolean consistencyCheckAfterGraphTrafoEnabled() {
        return this.consistencyCheckAfterGraphTrafo;
    }

    public boolean selectMatchObjectsEnabled() {
        return this.selectMatch;
    }

    public boolean showGraphAfterStepEnabled() {
        return this.showGraphAfterStep;
    }

    public boolean waitAfterStepEnabled() {
        return this.waitAfterStep;
    }

    public boolean checkRuleApplicabilityEnabled() {
        return this.checkRuleAppl;
    }

    public boolean applyParallelEnabled() {
        return this.parallelMatching;
    }

    public boolean selectNewAfterStepEnabled() {
        return this.selectNewAfterStep;
    }

    public void addActionListener(String option, ActionListener l) {
        if (option.equals("waitAfterStep")) {
            this.waitAfterStepCB.addActionListener(l);
        }
    }

    void setStrategyProperties(MorphCompletionStrategy s) {
        this.supportbits = s.getSupportedProperties();
        this.activebits = s.getProperties();
        int i = 0;
        while (i < CompletionPropertyBits.BITNAME.length) {
            this.checkboxBitNames.elementAt(i).setSelected(this.activebits.get(i));
            this.checkboxBitNames.elementAt(i).setEnabled(this.supportbits.get(i));
            ++i;
        }
        this.identCB.setEnabled(!this.injCB.isSelected());
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    @Override
    public void executeOnClose() {
    }
}

