/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.csp.StackItem;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Completion_SimpleBT
extends MorphCompletionStrategy {
    private boolean itsInjectiveFlag;
    private boolean initialized;
    private OrdinaryMorphism itsMorphism;
    private Vector<GraphObject> itsObjectsToMap;
    private Stack<StackItem> itsStack;
    private int itsState = 1;
    private HashMap<Integer, String> mapInputParameter = new HashMap(1);
    private String errorMsg;
    private static final int START = 1;
    private static final int SELECT = 2;
    private static final int MAP_NEXT = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_COMPLETIONS = 6;

    public Completion_SimpleBT(int i) {
        super(new BitSet(1));
        this.itsInjectiveFlag = false;
        this.itsName = "Simple BT";
    }

    public Completion_SimpleBT(boolean injective, int i) {
        super(new BitSet(1));
        this.itsInjectiveFlag = injective;
        this.itsName = "Simple BT";
    }

    @Override
    public final void initialize(OrdinaryMorphism morph) {
        this.itsMorphism = morph;
        this.itsStack = new Stack();
        this.itsObjectsToMap = new Vector();
        this.itsState = 1;
        for (GraphObject graphObject : this.itsMorphism.getOriginal().getNodesSet()) {
            if (this.itsMorphism.getImage(graphObject) != null) continue;
            this.itsObjectsToMap.add(graphObject);
        }
        for (GraphObject graphObject : this.itsMorphism.getOriginal().getArcsSet()) {
            if (this.itsMorphism.getImage(graphObject) != null) continue;
            this.itsObjectsToMap.add(graphObject);
        }
        this.initialized = true;
    }

    @Override
    public void setPartialMorphism(OrdinaryMorphism morph) {
        if (!this.initialized) {
            this.initialize(morph);
        } else {
            this.itsMorphism = morph;
            this.itsStack.clear();
            this.itsObjectsToMap.clear();
            this.itsState = 1;
            for (GraphObject graphObject : this.itsMorphism.getOriginal().getNodesSet()) {
                if (this.itsMorphism.getImage(graphObject) != null) continue;
                this.itsObjectsToMap.add(graphObject);
            }
            for (GraphObject graphObject : this.itsMorphism.getOriginal().getArcsSet()) {
                if (this.itsMorphism.getImage(graphObject) != null) continue;
                this.itsObjectsToMap.add(graphObject);
            }
        }
    }

    @Override
    public void resetTypeMap(Graph g) {
        this.refreshStack();
    }

    @Override
    public void resetTypeMap(Hashtable<String, HashSet<GraphObject>> typeMap) {
        this.refreshStack();
    }

    @Override
    public void resetVariableDomain(boolean instanceNull) {
        this.refreshStack();
    }

    private void refreshStack() {
        this.itsStack.clear();
        this.itsState = 1;
    }

    private final GraphObject nextMapping() {
        if (this.itsStack.empty()) {
            return null;
        }
        GraphObject obj = this.itsStack.peek().object;
        Enumeration<GraphObject> iter = this.itsStack.peek().iter;
        while (iter.hasMoreElements()) {
            try {
                GraphObject image = iter.nextElement();
                Enumeration<GraphObject> e = this.itsMorphism.getInverseImage(image);
                GraphObject o = null;
                if (e.hasMoreElements()) {
                    o = e.nextElement();
                }
                if (this.itsInjectiveFlag && o != null) continue;
                this.itsMorphism.addMapping(obj, image);
                if (this.itsMorphism.getImage(obj) == null) continue;
                return image;
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final void reset() {
    }

    @Override
    public final boolean next(OrdinaryMorphism morph) {
        this.errorMsg = "";
        this.storeValueOfInputParameter(morph);
        if (morph != this.itsMorphism) {
            this.initialize(morph);
        }
        if (this.itsState == 5) {
            this.itsState = 3;
        }
        block8: while (true) {
            switch (this.itsState) {
                case 1: {
                    if (this.itsMorphism.getOriginal().isEmpty()) {
                        this.itsState = 5;
                        continue block8;
                    }
                    this.itsState = 2;
                    continue block8;
                }
                case 2: {
                    GraphObject obj = this.selectObjectToMap();
                    if (obj == null) {
                        this.itsState = 5;
                        continue block8;
                    }
                    this.itsStack.push(new StackItem(obj, this.getDomain()));
                    this.itsState = 3;
                    continue block8;
                }
                case 3: {
                    GraphObject obj = this.nextMapping();
                    this.itsState = obj != null ? 2 : 4;
                    this.restoreValueOfInputParameter(morph);
                    continue block8;
                }
                case 4: {
                    if (this.itsStack.size() > 1) {
                        this.back();
                        this.itsState = 3;
                        continue block8;
                    }
                    this.itsState = 6;
                    continue block8;
                }
                case 5: {
                    if (!this.checkInputParameter(morph)) {
                        this.itsState = 3;
                        continue block8;
                    }
                    if (!this.checkObjectsWithSameVariable(morph)) {
                        this.itsState = 3;
                        continue block8;
                    }
                    if (!(morph instanceof NACStarMorphism) && !this.checkAttrCondition(morph)) {
                        this.itsState = 3;
                        continue block8;
                    }
                    this.restoreValueOfInputParameter(morph);
                    return true;
                }
                case 6: {
                    return false;
                }
            }
        }
    }

    private Enumeration<GraphObject> getDomain() {
        return this.itsMorphism.getImage().getElements();
    }

    private final void back() {
        GraphObject obj = this.itsStack.pop().object;
        this.itsObjectsToMap.add(0, obj);
        if (this.itsMorphism.getImage(obj) != null) {
            this.itsMorphism.removeMapping(obj);
        }
    }

    private final GraphObject selectObjectToMap() {
        if (this.itsObjectsToMap.isEmpty()) {
            return null;
        }
        GraphObject obj = this.itsObjectsToMap.get(0);
        this.itsObjectsToMap.remove(0);
        if (this.areReferencesMapped(obj)) {
            return obj;
        }
        this.itsObjectsToMap.add(obj);
        return this.selectObjectToMap();
    }

    private final boolean areReferencesMapped(GraphObject obj) {
        if (obj.isArc()) {
            return this.itsMorphism.getImage(((Arc)obj).getSource()) != null && this.itsMorphism.getImage(((Arc)obj).getTarget()) != null;
        }
        return true;
    }

    private void storeValueOfInputParameter(OrdinaryMorphism morph) {
        this.mapInputParameter = new HashMap(1);
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (avt != null) {
            int num = avt.getSize();
            int i = 0;
            while (i < num) {
                String val;
                VarMember var = avt.getVarMemberAt(i);
                if (var.isInputParameter() && (val = var.getExprAsText()) != null) {
                    Integer key = new Integer(i);
                    this.mapInputParameter.put(key, val);
                }
                ++i;
            }
        }
    }

    private void restoreValueOfInputParameter(OrdinaryMorphism morph) {
        if (morph.getAttrContext() == null) {
            return;
        }
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (Integer key : this.mapInputParameter.keySet()) {
                VarMember var;
                String val1;
                String val = this.mapInputParameter.get(key);
                if (val.equals(val1 = (var = avt.getVarMemberAt(key)).getExprAsText())) continue;
                var.setExprAsText(val);
                var.checkValidity();
            }
        }
    }

    private boolean checkInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (Integer key : this.mapInputParameter.keySet()) {
                String val = this.mapInputParameter.get(key);
                VarMember var = avt.getVarMemberAt(key);
                if (!var.isInputParameter()) continue;
                String val1 = var.getExprAsText();
                if (!(morph instanceof NACStarMorphism)) {
                    if (val1 == null || var.getMark() == 2 || var.getMark() == 3 || val.equals(val1)) continue;
                    this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                    return false;
                }
                if (val1 == null || var.getMark() != 2 || val.equals(val1)) continue;
                this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectsWithSameVariable(OrdinaryMorphism morph) {
        VarTuple variables = (VarTuple)morph.getAttrContext().getVariables();
        int i = 0;
        while (i < variables.getSize()) {
            ValueMember mem;
            int k;
            ValueTuple origVal;
            VarMember var = variables.getVarMemberAt(i);
            Vector<Pair<GraphObject, String>> v = new Vector<Pair<GraphObject, String>>();
            for (GraphObject graphObject : morph.getOriginal().getNodesSet()) {
                if (graphObject.getAttribute() == null) continue;
                origVal = (ValueTuple)graphObject.getAttribute();
                k = 0;
                while (k < origVal.getSize()) {
                    mem = origVal.getValueMemberAt(k);
                    if (mem.isSet() && mem.getExpr().isVariable() && mem.getExprAsText().equals(var.getName()) && mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem.getName()));
                    }
                    ++k;
                }
            }
            for (GraphObject graphObject : morph.getOriginal().getArcsSet()) {
                if (graphObject.getAttribute() == null) continue;
                origVal = (ValueTuple)graphObject.getAttribute();
                k = 0;
                while (k < origVal.getSize()) {
                    mem = origVal.getValueMemberAt(k);
                    if (mem.isSet() && mem.getExpr().isVariable() && mem.getExprAsText().equals(var.getName()) && mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem.getName()));
                    }
                    ++k;
                }
            }
            if (v.size() > 1) {
                Pair pair = (Pair)v.elementAt(0);
                GraphObject img = morph.getImage((GraphObject)pair.first);
                ValueTuple val = (ValueTuple)img.getAttribute();
                mem = val.getValueMemberAt((String)pair.second);
                int j = 1;
                while (j < v.size()) {
                    Pair pj = (Pair)v.elementAt(j);
                    GraphObject imgj = morph.getImage((GraphObject)pj.first);
                    ValueTuple valj = (ValueTuple)imgj.getAttribute();
                    ValueMember memj = valj.getValueMemberAt((String)pj.second);
                    if (!mem.getExprAsText().equals(memj.getExprAsText())) {
                        this.errorMsg = "Attribute match is failed.";
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkAttrCondition(OrdinaryMorphism morph) {
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEnabled() && cond.isDefinite() && !cond.isTrue()) {
                this.errorMsg = "Attribute condition  [ " + cond.getExprAsText() + " ]  failed.";
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

