/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationListener;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MemberAnnotationChangedEvent;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.Messages;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAnnotationManager
implements IMemberAnnotationManager,
IElementChangedListener {
    private static final Pattern GENERATED = Pattern.compile("@generated([\\s]+NOT)?");
    private static int MAX_CACHE_SIZE = 64;
    private static long CACHE_INTERVAL = 2000L;
    private final ListenerList listeners = new ListenerList();
    private final Map<IMember, CachedStatus> statusCache = new LinkedHashMap<IMember, CachedStatus>();
    private final CacheCleaner cacheCleaner = new CacheCleaner();

    public MemberAnnotationManager() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)4);
    }

    @Override
    public void addMemberAnnotationListener(IMemberAnnotationListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeMemberAnnotationListener(IMemberAnnotationListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeGenStatus getCodeGenStatus(IMember member) {
        Map<IMember, CachedStatus> map = this.statusCache;
        synchronized (map) {
            CachedStatus status = this.statusCache.remove(member);
            if (status == null) {
                CodeGenStatus value = this.getCodeGenStatusChecked(member);
                status = new CachedStatus(value);
            }
            status.timestamp = System.currentTimeMillis();
            this.statusCache.put(member, status);
            this.cacheCleaner.schedule();
            return status.value;
        }
    }

    private CodeGenStatus getCodeGenStatusChecked(IMember member) {
        CodeGenStatus value = CodeGenStatus.NONE;
        try {
            value = this.computeCodeGenStatus(member);
        }
        catch (JavaModelException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorCodegenStatus, e);
        }
        catch (IOException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorCodegenStatus, e);
        }
        return value;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        if ((delta.getKind() & 4) == 0) {
            return;
        }
        IJavaElement element = delta.getElement();
        int flags = delta.getFlags();
        if (element instanceof ICompilationUnit && (flags & 0x80000) != 0 && (flags & 0x4000) != 0 && (flags & 9) != 0) {
            ArrayList<IMember> members = new ArrayList<IMember>();
            this.collectMembers(element, members);
            HashMap<IMember, CodeGenStatus> changes = new HashMap<IMember, CodeGenStatus>();
            this.computeChanges(members, changes);
            if (!changes.isEmpty()) {
                this.fireMemberAnnotationChangedEvent(new MemberAnnotationChangedEvent(this, changes));
            }
        }
    }

    private void collectMembers(IJavaElement element, Collection<IMember> collector) {
        IJavaElement[] children;
        if (element instanceof IMember) {
            collector.add((IMember)element);
        }
        if (!(element instanceof IParent)) {
            return;
        }
        try {
            children = ((IParent)element).getChildren();
        }
        catch (JavaModelException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorJavaModel, e);
            return;
        }
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (!(child instanceof IInitializer)) {
                this.collectMembers(child, collector);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChanges(Collection<IMember> members, Map<IMember, CodeGenStatus> changes) {
        Map<IMember, CachedStatus> map = this.statusCache;
        synchronized (map) {
            for (IMember member : members) {
                CachedStatus status = this.statusCache.remove(member);
                if (status == null) continue;
                CodeGenStatus value = this.getCodeGenStatusChecked(member);
                if (value != status.value) {
                    status.value = value;
                    changes.put(member, value);
                }
                status.timestamp = System.currentTimeMillis();
                this.statusCache.put(member, status);
                this.cacheCleaner.schedule();
            }
        }
    }

    private void fireMemberAnnotationChangedEvent(final MemberAnnotationChangedEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            final IMemberAnnotationListener listener = (IMemberAnnotationListener)obj;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.memberAnnotationChanged(event);
                }

                public void handleException(Throwable e) {
                    MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorNotifyListener, e);
                }
            });
            ++n2;
        }
    }

    private CodeGenStatus computeCodeGenStatus(IMember member) throws JavaModelException, IOException {
        CodeGenStatus result = CodeGenStatus.NONE;
        if (!member.exists()) {
            return result;
        }
        String javadoc = this.getJavadoc(member);
        if (javadoc == null) {
            return result;
        }
        Matcher m = GENERATED.matcher(javadoc);
        if (m.find()) {
            result = m.group(1) == null ? CodeGenStatus.GENERATED : CodeGenStatus.GENERATED_NOT;
        }
        return result;
    }

    private String getJavadoc(IMember member) throws JavaModelException {
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange range = member.getJavadocRange();
        if (range != null) {
            return buf.getText(range.getOffset(), range.getLength());
        }
        return null;
    }

    public void dispose() {
        this.cacheCleaner.cancel();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.listeners.clear();
    }

    private class CacheCleaner
    extends Job {
        public CacheCleaner() {
            super(Messages.MemberAnnotationManager_JobCacheCleaner);
            this.setSystem(true);
            this.setPriority(50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Map map = MemberAnnotationManager.this.statusCache;
            synchronized (map) {
                long threshold = System.currentTimeMillis() - CACHE_INTERVAL;
                Iterator i = MemberAnnotationManager.this.statusCache.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    CachedStatus status = (CachedStatus)entry.getValue();
                    if (status.timestamp >= threshold || MemberAnnotationManager.this.statusCache.size() <= MAX_CACHE_SIZE) break;
                    i.remove();
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class CachedStatus {
        public CodeGenStatus value;
        public long timestamp;

        public CachedStatus(CodeGenStatus value) {
            this.value = value;
        }
    }
}

