/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;

public class GenEnumLiteralItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays.asList(
			GenModelPackage.Literals.GEN_ENUM_LITERAL__GEN_ENUM,
			GenModelPackage.Literals.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList();

	public GenEnumLiteralItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenEnumLiteral genEnumLiteral = (GenEnumLiteral) object;
		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genEnumLiteral.getGenModel();
		String modelDir = genModel.getModelDirectory();

		addField(modelDir, genEnumLiteral.getGenEnum().getQualifiedName(),
				genEnumLiteral.getEnumLiteralInstanceConstantName(),
				CAT_INTERFACE,
				Messages.GenEnumLiteralItemProvider_LiteralLabel,
				Messages.GenEnumLiteralItemProvider_LiteralDescription,
				GenModelPackage.Literals.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL,
				list);
		addField(modelDir, genEnumLiteral.getGenEnum().getQualifiedName(),
				genEnumLiteral.getEnumLiteralValueConstantName(),
				CAT_INTERFACE, Messages.GenEnumLiteralItemProvider_ValueLabel,
				Messages.GenEnumLiteralItemProvider_ValueDescription,
				GenModelPackage.Literals.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL,
				list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenEnumLiteral(GenEnumLiteral object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenEnumLiteral(
					GenEnumLiteral object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
