/*******************************************************************************
 * Copyright (c) 2007 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

/**
 * Class responsible for determining and tracking the {@link CodeGenStatus code
 * generation status} of Java type members (namely {@link IField fields},
 * {@link IMethod methods}, and {@link IType types}). Changes to the status of
 * members that have been recently inquired about is tracked and registered
 * {@link #addMemberAnnotationListener(IMemberAnnotationListener) listeners} are
 * notified.
 * <p>
 * The singleton instance of this class can be obtained by calling
 * {@link MintCore#getMemberAnnotationManager()}.
 * </p>
 */
public interface IMemberAnnotationManager {

	/**
	 * Adds a member annotation listener.
	 * 
	 * @param listener
	 *            the listener to add
	 */
	void addMemberAnnotationListener(IMemberAnnotationListener listener);

	/**
	 * Removes a member annotation listener.
	 * 
	 * @param listener
	 *            the listener to remove
	 */
	void removeMemberAnnotationListener(IMemberAnnotationListener listener);

	/**
	 * Returns the {@link CodeGenStatus code generation status} of the given
	 * member.
	 * 
	 * @param member
	 *            Java type member whose code generation status to return
	 * @return member's code generation status
	 */
	CodeGenStatus getCodeGenStatus(IMember member);
}
