/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;

public class GenEnumItemProvider extends GenDataTypeItemProvider {

	protected static final List<EReference> GROUP_REFERENCES = appendList(
			GenClassifierItemProvider.GROUP_REFERENCES,
			GenModelPackage.Literals.GEN_ENUM__ECORE_ENUM);

	public GenEnumItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenEnum genEnum = (GenEnum) object;
		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genEnum.getGenModel();
		String modelDir = genModel.getModelDirectory();
		addType(modelDir, genEnum.getQualifiedInstanceClassName(),
				CAT_IMPLEMENTATION,
				Messages.GenEnumItemProvider_InstanceClassLabel,
				Messages.GenEnumItemProvider_InstanceClassDescription, null,
				list);
		addType(modelDir, genEnum.getQualifiedName(), CAT_INTERFACE,
				Messages.GenEnumItemProvider_EnumerationLabel,
				Messages.GenEnumItemProvider_EnumerationDescription,
				GenModelPackage.Literals.GEN_ENUM__ECORE_ENUM, list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GenDataTypeGroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenEnum(GenEnum object) {
				return GROUP_REFERENCES;
			}
		};
	}
}
