/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.source;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.mint.internal.ui.source.Messages;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class CustomizeGeneratedMethodOperation
implements IWorkspaceRunnable {
    private static final String NOT_PARAM = "NOT";
    private static final String GENERATED_TAG = "@generated";
    private static final String GEN_SUFFIX = "Gen";
    private IMethod[] methods;

    public CustomizeGeneratedMethodOperation(IMethod[] methods) {
        this.methods = methods;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.methods.length == 0) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 3 * this.methods.length + 1);
        try {
            this.doRun(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void doRun(IProgressMonitor monitor) throws CoreException {
        ICompilationUnit cu = this.methods[0].getCompilationUnit();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit astRoot = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        parser.setProject(cu.getJavaProject());
        IBinding[] bindings = parser.createBindings((IJavaElement[])this.methods, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITextFileBufferManager manager = ITextFileBufferManager.DEFAULT;
        IPath path = cu.getPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                IDocument document = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
                int i = 0;
                while (i < this.methods.length) {
                    IMethod method = this.methods[i];
                    if (cu.equals(method.getCompilationUnit())) {
                        monitor.subTask(method.getElementName());
                        MethodDeclaration decl = (MethodDeclaration)astRoot.findDeclaringNode(bindings[i].getKey());
                        if (decl == null) {
                            String msg = NLS.bind((String)Messages.CustomizeGeneratedMethodOperation_ErrorMethodDecl, (Object)method);
                            Status status = new Status(4, "org.eclipse.emf.mint", 0, msg, null);
                            throw new CoreException((IStatus)status);
                        }
                        MethodDeclaration genDecl = (MethodDeclaration)ASTNode.copySubtree((AST)astRoot.getAST(), (ASTNode)decl);
                        SimpleName genName = astRoot.getAST().newSimpleName(String.valueOf(decl.getName().getIdentifier()) + GEN_SUFFIX);
                        genDecl.setName(genName);
                        Javadoc javadoc = genDecl.getJavadoc();
                        TagElement oldGeneratedTag = this.findGeneratedTag(javadoc);
                        TagElement generatedTag = astRoot.getAST().newTagElement();
                        generatedTag.setTagName(GENERATED_TAG);
                        if (oldGeneratedTag == null) {
                            javadoc.tags().add(generatedTag);
                        } else {
                            javadoc.tags().set(javadoc.tags().indexOf(oldGeneratedTag), generatedTag);
                        }
                        ListRewrite listRewrite = rewrite.getListRewrite(decl.getParent(), TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                        listRewrite.insertBefore((ASTNode)genDecl, (ASTNode)decl, null);
                        MethodInvocation inv = astRoot.getAST().newMethodInvocation();
                        inv.setName(astRoot.getAST().newSimpleName(genDecl.getName().getIdentifier()));
                        for (SingleVariableDeclaration p : decl.parameters()) {
                            inv.arguments().add(astRoot.getAST().newSimpleName(p.getName().getIdentifier()));
                        }
                        Block block = astRoot.getAST().newBlock();
                        if (decl.getReturnType2().isPrimitiveType() && PrimitiveType.VOID.equals(((PrimitiveType)decl.getReturnType2()).getPrimitiveTypeCode())) {
                            ExpressionStatement stmt = astRoot.getAST().newExpressionStatement((Expression)inv);
                            block.statements().add(stmt);
                        } else {
                            ReturnStatement ret = astRoot.getAST().newReturnStatement();
                            ret.setExpression((Expression)inv);
                            block.statements().add(ret);
                        }
                        rewrite.replace((ASTNode)decl.getBody(), (ASTNode)block, null);
                        javadoc = decl.getJavadoc();
                        oldGeneratedTag = this.findGeneratedTag(javadoc);
                        generatedTag = astRoot.getAST().newTagElement();
                        generatedTag.setTagName(GENERATED_TAG);
                        TextElement notElement = astRoot.getAST().newTextElement();
                        notElement.setText(NOT_PARAM);
                        generatedTag.fragments().add(notElement);
                        listRewrite = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                        if (oldGeneratedTag == null) {
                            listRewrite.insertLast((ASTNode)generatedTag, null);
                        } else {
                            listRewrite.replace((ASTNode)oldGeneratedTag, (ASTNode)generatedTag, null);
                        }
                    }
                    ++i;
                }
                TextEdit edit = rewrite.rewriteAST();
                edit.apply(document, 2);
            }
            catch (BadLocationException e) {
                Status status = new Status(4, "org.eclipse.emf.mint", 0, Messages.CustomizeGeneratedMethodOperation_ErrorBadLocation, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private TagElement findGeneratedTag(Javadoc javadoc) {
        TagElement generatedTag = null;
        for (TagElement tag : javadoc.tags()) {
            if (!GENERATED_TAG.equals(tag.getTagName())) continue;
            generatedTag = tag;
            break;
        }
        return generatedTag;
    }
}

