/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;

public class IssuesImpl
implements Issues {
    private final List<MWEDiagnostic> issues = new ArrayList<MWEDiagnostic>();

    @Override
    public void add(MWEDiagnostic issue) {
        this.issues.add(issue);
    }

    @Override
    public void addError(WorkflowComponent ctx, String msg, Object obj, String feature, Throwable t, List<Object> additionalData) {
        this.add(IssuesImpl.createError(ctx, msg, obj, feature, t, additionalData));
    }

    @Override
    public void addError(WorkflowComponent ctx, String msg, Object element, Throwable t, List<Object> additionalData) {
        this.addError(ctx, msg, element, null, t, additionalData);
    }

    @Override
    public void addError(WorkflowComponent ctx, String msg) {
        this.addError(ctx, msg, null, null, Collections.emptyList());
    }

    @Override
    public void addError(String msg, Object element) {
        this.addError(null, msg, element, null, Collections.emptyList());
    }

    @Override
    public void addError(String msg) {
        this.addError(msg, null);
    }

    @Override
    public void addError(WorkflowComponent compnent, String msg, Object obj) {
        this.addError(compnent, msg, obj, null, Collections.emptyList());
    }

    @Override
    public boolean hasErrors() {
        return this.getErrors().length != 0;
    }

    @Override
    public MWEDiagnostic[] getErrors() {
        return this.filterIssues(4);
    }

    @Override
    public void addWarning(WorkflowComponent ctx, String msg) {
        this.addWarning(ctx, msg, null, null, Collections.emptyList());
    }

    @Override
    public void addWarning(String msg, Object element) {
        this.addWarning(null, msg, element, null, Collections.emptyList());
    }

    @Override
    public void addWarning(WorkflowComponent ctx, String msg, Object element, Throwable t, List<Object> additionalData) {
        this.addWarning(ctx, msg, element, null, t, additionalData);
    }

    @Override
    public void addWarning(WorkflowComponent ctx, String msg, Object element, String feature, Throwable t, List<Object> additionalData) {
        this.add(IssuesImpl.createWarning(ctx, msg, element, feature, t, additionalData));
    }

    @Override
    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    @Override
    public void addWarning(WorkflowComponent compnent, String msg, Object obj) {
        this.addWarning(compnent, msg, obj, null, Collections.emptyList());
    }

    @Override
    public MWEDiagnostic[] getWarnings() {
        return this.filterIssues(2);
    }

    @Override
    public boolean hasWarnings() {
        return this.getWarnings().length != 0;
    }

    @Override
    public void addInfo(WorkflowComponent ctx, String msg) {
        this.addInfo(ctx, msg, null, null, Collections.emptyList());
    }

    @Override
    public void addInfo(String msg, Object element) {
        this.addInfo(null, msg, element, null, Collections.emptyList());
    }

    @Override
    public void addInfo(WorkflowComponent ctx, String msg, Object element, Throwable t, List<Object> additionalData) {
        this.addInfo(ctx, msg, element, null, t, additionalData);
    }

    @Override
    public void addInfo(WorkflowComponent ctx, String msg, Object element, String featureName, Throwable t, List<Object> additionalData) {
        this.add(IssuesImpl.createInfo(ctx, msg, element, featureName, t, additionalData));
    }

    @Override
    public void addInfo(WorkflowComponent compnent, String msg, Object obj) {
        this.addInfo(compnent, msg, obj, null, Collections.emptyList());
    }

    @Override
    public void addInfo(String msg) {
        this.addInfo(msg, null);
    }

    @Override
    public MWEDiagnostic[] getInfos() {
        return this.filterIssues(1);
    }

    @Override
    public boolean hasInfos() {
        return this.getInfos().length != 0;
    }

    public String toString() {
        MWEDiagnostic issue;
        MWEDiagnostic[] issues;
        StringBuffer buff = new StringBuffer();
        MWEDiagnostic[] mWEDiagnosticArray = issues = this.getInfos();
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            buff.append("\n" + issue.toString());
            ++n2;
        }
        mWEDiagnosticArray = issues = this.getWarnings();
        n = issues.length;
        n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            buff.append("\n" + issue.toString());
            ++n2;
        }
        mWEDiagnosticArray = issues = this.getErrors();
        n = issues.length;
        n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            buff.append("\n" + issue.toString());
            ++n2;
        }
        return buff.toString();
    }

    @Override
    public void clear() {
        this.issues.clear();
    }

    private static MWEDiagnostic createDiagnostic(int severity, WorkflowComponent ctx, String msg, Object element, String feature, Throwable t, List<Object> additionalData) {
        MWEDiagnostic diagnostic = new MWEDiagnostic(severity, msg, element, feature, t, additionalData, ctx);
        return diagnostic;
    }

    static MWEDiagnostic createInfo(WorkflowComponent ctx, String msg, Object element, String featureName, Throwable t, List<Object> additionalData) {
        MWEDiagnostic diagnostic = IssuesImpl.createDiagnostic(1, ctx, msg, element, featureName, t, additionalData);
        return diagnostic;
    }

    private static MWEDiagnostic createWarning(WorkflowComponent ctx, String msg, Object element, String feature, Throwable t, List<Object> additionalData) {
        MWEDiagnostic diagnostic = IssuesImpl.createDiagnostic(2, ctx, msg, element, feature, t, additionalData);
        return diagnostic;
    }

    private static MWEDiagnostic createError(WorkflowComponent ctx, String msg, Object element, String feature, Throwable t, List<Object> additionalData) {
        MWEDiagnostic diagnostic = IssuesImpl.createDiagnostic(4, ctx, msg, element, feature, t, additionalData);
        return diagnostic;
    }

    private MWEDiagnostic[] filterIssues(int severity) {
        ArrayList<MWEDiagnostic> result = new ArrayList<MWEDiagnostic>();
        for (MWEDiagnostic diagnostic : this.issues) {
            if (diagnostic.getSeverity() != severity) continue;
            result.add(diagnostic);
        }
        return result.toArray(new MWEDiagnostic[result.size()]);
    }

    @Override
    public MWEDiagnostic[] getIssues() {
        return this.issues.toArray(new MWEDiagnostic[this.issues.size()]);
    }
}

