/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.ui.pde.internal.l10n;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.examples.ui.pde.internal.GmfExamplesDebugOptions;
import org.eclipse.gmf.examples.ui.pde.internal.GmfExamplesPlugin;
import org.eclipse.gmf.examples.ui.pde.internal.l10n.EmptyResourceBundle;
import org.eclipse.gmf.examples.ui.pde.internal.l10n.ResourceManager;
import org.eclipse.gmf.examples.ui.pde.util.Log;
import org.eclipse.gmf.examples.ui.pde.util.Trace;

public abstract class AbstractResourceManager {
    private static final String MESSAGES = ".messages";
    private static final String MISSING_RESOURCE_MESSAGE = "Attempt to access missing resource ({0}).";
    static final String KEY_LIST_SEPARATOR = "list.separator";
    static final String KEY_LIST_SEPARATOR_ONLY = "list.separator.only";
    static final String KEY_LIST_SEPARATOR_FIRST = "list.separator.first";
    static final String KEY_LIST_SEPARATOR_LAST = "list.separator.last";
    static final String KEY_LIST_PREFIX = "list.prefix";
    static final String KEY_LIST_SUFFIX = "list.suffix";
    static final String DEFAULT_LIST_SEPARATOR = ", ";
    static final String DEFAULT_LIST_PREFIX = "";
    static final String DEFAULT_LIST_SUFFIX = "";
    private ResourceBundle messagesBundle = null;
    private String messagesBundleName = this.getMessagesBundleDefaultName();
    static /* synthetic */ Class class$0;

    protected AbstractResourceManager() {
        this.initializeResources();
    }

    protected ResourceBundle getMessagesBundle() {
        return this.messagesBundle;
    }

    protected String getPackageName() {
        return this.getClass().getPackage().getName();
    }

    protected String getMessagesBundleName() {
        return this.messagesBundleName;
    }

    protected abstract Plugin getPlugin();

    protected abstract void initializeResources();

    protected void initializeMessageResources() {
        this.messagesBundle = this.createMessagesBundle();
    }

    protected ResourceBundle createMessagesBundle() {
        try {
            return ResourceBundle.getBundle(this.getMessagesBundleName(), Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (MissingResourceException mre) {
            Trace.catching((Plugin)GmfExamplesPlugin.getDefault(), GmfExamplesDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "createMessagesBundle", mre);
            Log.error((Plugin)GmfExamplesPlugin.getDefault(), 3, "createMessagesBundle", mre);
            return new EmptyResourceBundle(this.getMessagesBundleName());
        }
    }

    public String getString(String key) {
        return this.getString(key, key);
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getMessagesBundle().getString(key);
        }
        catch (MissingResourceException mre) {
            Trace.catching((Plugin)GmfExamplesPlugin.getDefault(), GmfExamplesDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "getString", mre);
            Log.warning((Plugin)GmfExamplesPlugin.getDefault(), 3, MessageFormat.format(MISSING_RESOURCE_MESSAGE, key), mre);
            return defaultValue;
        }
    }

    public String formatMessage(String patternKey, Object[] args) {
        String pattern = this.getString(patternKey);
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (Exception e) {
            Plugin plugin = this.getPlugin();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.examples.ui.pde.internal.l10n.ResourceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching(plugin, GmfExamplesDebugOptions.EXCEPTIONS_CATCHING, clazz, "messageFormat", e);
            return pattern;
        }
    }

    public String formatList(String[] strings) {
        return this.formatList(Arrays.asList(strings));
    }

    public String formatList(Collection items) {
        switch (items.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(items.iterator().next());
            }
            case 2: {
                return this.formatPair(ResourceManager.getInstance(), items);
            }
        }
        return this.formatList(ResourceManager.getInstance(), items);
    }

    private String formatPair(AbstractResourceManager mgr, Collection items) {
        Iterator iter = items.iterator();
        StringBuffer result = new StringBuffer(32);
        result.append(iter.next());
        result.append(mgr.getString(KEY_LIST_SEPARATOR_ONLY, mgr.getString(KEY_LIST_SEPARATOR, DEFAULT_LIST_SEPARATOR)));
        result.append(iter.next());
        return result.toString();
    }

    private String formatList(AbstractResourceManager mgr, Collection items) {
        Iterator iter = items.iterator();
        int max = items.size() - 1;
        String sep = mgr.getString(KEY_LIST_SEPARATOR, DEFAULT_LIST_SEPARATOR);
        StringBuffer result = new StringBuffer(32);
        result.append(mgr.getString(KEY_LIST_PREFIX, ""));
        int i = 0;
        while (i <= max) {
            if (i == 1) {
                result.append(mgr.getString(KEY_LIST_SEPARATOR_FIRST, sep));
            } else if (i == max) {
                result.append(mgr.getString(KEY_LIST_SEPARATOR_LAST, sep));
            } else if (i > 1) {
                result.append(sep);
            }
            result.append(iter.next());
            ++i;
        }
        result.append(mgr.getString(KEY_LIST_SUFFIX, ""));
        return result.toString();
    }

    protected String getMessagesBundleDefaultName() {
        return String.valueOf(this.getPackageName()) + MESSAGES;
    }
}

