/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;

public class OrthogonalRouterUtilities {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static Point getAdjustedCenterPoint(Rectangle rect, Point ref) {
        Point ptNewCenter = new Point(rect.getCenter());
        if (ref.x < rect.getRight().x && ref.x > rect.getLeft().x) {
            ptNewCenter.x = ref.x;
        } else if (ref.y < rect.getBottom().y && ref.y > rect.getTop().y) {
            ptNewCenter.y = ref.y;
        }
        return ptNewCenter;
    }

    public static void resetEndPointsToCenter(Connection conn, PointList newLine) {
        Rectangle startRect = OrthogonalRouterUtilities.getBounds(conn.getSourceAnchor().getOwner());
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        Point ptStart = newLine.getPoint(1);
        conn.translateToAbsolute((Translatable)ptStart);
        ptStart = OrthogonalRouterUtilities.getAdjustedCenterPoint(startRect, ptStart);
        conn.translateToRelative((Translatable)ptStart);
        newLine.setPoint(ptStart, 0);
        Rectangle endRect = OrthogonalRouterUtilities.getBounds(conn.getTargetAnchor().getOwner());
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        Point ptEnd = newLine.getPoint(newLine.size() - 2);
        conn.translateToAbsolute((Translatable)ptEnd);
        ptEnd = OrthogonalRouterUtilities.getAdjustedCenterPoint(endRect, ptEnd);
        conn.translateToRelative((Translatable)ptEnd);
        newLine.setPoint(ptEnd, newLine.size() - 1);
    }

    private static Point getEdgePoint(Connection conn, ConnectionAnchor anchor, Point ptRef) {
        Rectangle rect = OrthogonalRouterUtilities.getBounds(anchor.getOwner());
        anchor.getOwner().translateToAbsolute((Translatable)rect);
        conn.translateToRelative((Translatable)rect);
        Point ptRef2 = new Point(ptRef);
        Point ptRef1 = OrthogonalRouterUtilities.getAdjustedCenterPoint(rect, ptRef2);
        Point ptAbsRef2 = new Point(ptRef2);
        conn.translateToAbsolute((Translatable)ptAbsRef2);
        Point ptEdge = anchor.getLocation(ptAbsRef2);
        conn.translateToRelative((Translatable)ptEdge);
        LineSeg lineSeg = new LineSeg(ptRef1, ptRef2);
        Point ptProj = lineSeg.perpIntersect(ptEdge.x, ptEdge.y);
        if (Math.abs(ptProj.x - ptRef2.x) < Math.abs(ptProj.y - ptRef2.y)) {
            ptProj.x = ptRef2.x;
        } else {
            ptProj.y = ptRef2.y;
        }
        return ptProj;
    }

    public static LineSeg getOrthogonalLineSegToAnchorLoc(Connection conn, ConnectionAnchor anchor, Point ref) {
        if (!($assertionsDisabled || anchor != null && anchor.getOwner() != null)) {
            throw new AssertionError();
        }
        Point ptAbsRef = OrthogonalRouterUtilities.getEdgePoint(conn, anchor, ref);
        conn.translateToAbsolute((Translatable)ptAbsRef);
        Point ptEdge = anchor.getLocation(ptAbsRef);
        conn.translateToRelative((Translatable)ptEdge);
        LineSeg result = new LineSeg(ptEdge, ref);
        if (!result.isHorizontal() && !result.isVertical()) {
            if (Math.abs(result.getOrigin().x - result.getTerminus().x) < Math.abs(result.getOrigin().y - result.getTerminus().y)) {
                result.setTerminus(new Point(result.getOrigin().x, result.getTerminus().y));
            } else {
                result.setTerminus(new Point(result.getTerminus().x, result.getOrigin().y));
            }
        }
        return result;
    }

    private static Rectangle getBounds(IFigure figure) {
        return figure instanceof Connection ? ((Connection)figure).getPoints().getBounds().getCopy() : figure.getBounds().getCopy();
    }
}

