/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.commands.CommandTestFixture;

public class SetBoundsCommandTest
extends CommandTestFixture {
    private int XPOS = 500;
    private int YPOS = 500;
    private int WIDTH = 50;
    private int HEIGHT = 50;

    protected ICommand createCommand() {
        return new SetBoundsCommand(this.getEditingDomain(), "SetBounds", (IAdaptable)new EObjectAdapter((EObject)this.noteView), new Rectangle(0, 0, this.WIDTH, this.HEIGHT));
    }

    public void testDoExecute() {
        SetBoundsCommandTest.assertTrue((boolean)this.getCommand().canExecute());
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()));
        try {
            this.getCommand().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            SetBoundsCommandTest.fail((String)e.getLocalizedMessage());
        }
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.WIDTH), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.HEIGHT), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()));
    }

    public void testMove() {
        SetBoundsCommand moveCommand = new SetBoundsCommand(this.getEditingDomain(), "SetBounds Move Test", (IAdaptable)new EObjectAdapter((EObject)this.noteView), new Point(this.XPOS, this.YPOS));
        SetBoundsCommandTest.assertTrue((boolean)moveCommand.canExecute());
        SetBoundsCommandTest.assertEquals((Object)new Integer(0), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(0), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()));
        try {
            moveCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            SetBoundsCommandTest.fail((String)e.getLocalizedMessage());
        }
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.XPOS), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.YPOS), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()));
    }

    public void testResize() {
        SetBoundsCommand resizeCommand = new SetBoundsCommand(this.getEditingDomain(), "SetBounds Move Test", (IAdaptable)new EObjectAdapter((EObject)this.noteView), new Dimension(this.WIDTH, this.HEIGHT));
        SetBoundsCommandTest.assertTrue((boolean)resizeCommand.canExecute());
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(-1), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()));
        try {
            resizeCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            SetBoundsCommandTest.fail((String)e.getLocalizedMessage());
        }
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.WIDTH), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()));
        SetBoundsCommandTest.assertEquals((Object)new Integer(this.HEIGHT), (Object)ViewUtil.getStructuralFeatureValue((View)this.noteView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()));
    }
}

