/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.framework;

import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.ui.util.FileUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.TestsPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class DiagramTestCase
extends TestCase {
    private IProject project = null;
    private IDiagramWorkbenchPart diagramWorkbenchPart = null;
    private IFile diagramFile = null;
    private Diagram diagramView;
    private TransactionalEditingDomain editingDomain;
    private Resource resource;

    public DiagramTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.createProject();
        this.setDiagramFile(this.createDiagram());
        this.createResource();
        this.openDiagram();
        this.flushEventQueue();
        this.createShapesAndConnectors();
    }

    protected void tearDown() throws Exception {
        this.flushEventQueue();
        this.closeDiagram();
        this.diagramView = null;
        this.resource.unload();
        this.resource = null;
        this.closeProject();
    }

    protected IFile getDiagramFile() {
        return this.diagramFile;
    }

    protected Diagram getDiagram() {
        return this.diagramView;
    }

    protected void setDiagram(Diagram diagram) {
        this.diagramView = diagram;
    }

    protected void setDiagramFile(IFile theFile) {
        this.diagramFile = theFile;
    }

    protected String getProjectName() {
        return "pxdemodelproj";
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void createProject() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = workspace.getRoot();
        this.project = wsroot.getProject(this.getProjectName());
        IProjectDescription desc = workspace.newProjectDescription(this.project.getName());
        if (!this.project.exists()) {
            this.project.create(desc, null);
        }
        if (!this.project.isOpen()) {
            this.project.open(null);
        }
    }

    protected void createResource() {
        IFile file = this.getDiagramFile();
        if (file != null) {
            String filePath = file.getLocation().toOSString();
            this.resource = this.getEditingDomain().loadResource(filePath);
        } else {
            this.resource = this.getEditingDomain().createResource("null:/org.eclipse.gmf.tests.runtime.diagram.ui");
        }
        Diagram d = this.getDiagram();
        if (d != null) {
            AbstractEMFOperation operation = new AbstractEMFOperation(this.getEditingDomain(), "AbstractPresentationTestFixture setup"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    DiagramTestCase.this.resource.getContents().add((Object)DiagramTestCase.this.getDiagram());
                    return Status.OK_STATUS;
                }
            };
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ie) {
                DiagramTestCase.fail((String)("createResource failed: " + ie.getLocalizedMessage()));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeProject() {
        try {
            try {
                this.project.delete(true, true, null);
            }
            catch (CoreException e) {
                Log.error((Plugin)TestsPlugin.getDefault(), (int)4, (String)"Failed to delete project", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.project = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.project = null;
            return;
        }
    }

    protected void deleteDiagramFile() throws Exception {
        FileUtil.deleteFile((IFile)this.getDiagramFile(), (IProgressMonitor)new NullProgressMonitor());
    }

    protected void closeDiagram() {
        if (this.getDiagramWorkbenchPart() instanceof IEditorPart) {
            IWorkbenchPage page = this.getDiagramWorkbenchPart().getSite().getPage();
            page.closeEditor((IEditorPart)this.getDiagramWorkbenchPart(), false);
        }
        this.setDiagramWorkbenchPart(null);
        this.setDiagramFile(null);
    }

    protected void flushEventQueue() {
        Display display = Display.getDefault();
        while (display.readAndDispatch()) {
        }
    }

    public IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        return this.diagramWorkbenchPart;
    }

    protected void setDiagramWorkbenchPart(IDiagramWorkbenchPart diagramWorkbenchPart) {
        this.diagramWorkbenchPart = diagramWorkbenchPart;
    }

    public DiagramEditPart getDiagramEditPart() {
        DiagramTestCase.assertNotNull((Object)this.getDiagramWorkbenchPart());
        return this.getDiagramWorkbenchPart().getDiagramEditPart();
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.getDiagramWorkbenchPart().getSite().getPage();
    }

    protected abstract IFile createDiagram() throws Exception;

    protected void openDiagram() throws Exception {
        if (this.getDiagramFile() == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.setDiagramWorkbenchPart((IDiagramWorkbenchPart)IDE.openEditor((IWorkbenchPage)page, (IFile)this.getDiagramFile(), (boolean)true));
    }

    protected abstract void createShapesAndConnectors() throws Exception;

    public TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        }
        return this.editingDomain;
    }
}

