/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate.expressions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.Messages;
import org.eclipse.osgi.util.NLS;

public class ExpressionProviderRegistry {
    private static final ExpressionProviderRegistry INSTANCE;
    private Map registry = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        INSTANCE = new ExpressionProviderRegistry();
    }

    private ExpressionProviderRegistry() {
        this.initialiaze();
    }

    public static ExpressionProviderRegistry getInstance() {
        return INSTANCE;
    }

    public IModelExpressionProvider getProvider(String language) {
        Descriptor descriptor = this.getDescriptor(language);
        if (descriptor != null && descriptor.getStatus().isOK()) {
            return descriptor.getProvider();
        }
        return null;
    }

    public Set getLanguages() {
        return this.registry.keySet();
    }

    public Descriptor getDescriptor(String language) {
        return (Descriptor)this.registry.get(language);
    }

    private void initialiaze() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(Descriptor.GLOBAL_EXTENSION_ID);
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement element = configs[i];
            Descriptor descriptor = new Descriptor(element);
            if (descriptor.getStatus().isOK()) {
                String lang = descriptor.getLanguage();
                if (!$assertionsDisabled && lang == null) {
                    throw new AssertionError();
                }
                Descriptor currentDsc = (Descriptor)this.registry.get(lang);
                if (currentDsc == null) {
                    this.registry.put(lang, descriptor);
                } else {
                    String message = NLS.bind((String)Messages.providerAlreadyExistsIgnore, (Object[])new Object[]{currentDsc.getProviderClassName(), lang, descriptor.getProviderClassName()});
                    GMFValidationPlugin.log(GMFValidationPlugin.createStatus(4, 0, message, null));
                }
            }
            ++i;
        }
        this.registry = Collections.unmodifiableMap(this.registry);
    }

    static class Descriptor {
        static final String EXTENSION_ID = "expressionProviders";
        static final String GLOBAL_EXTENSION_ID = String.valueOf(GMFValidationPlugin.getPluginId()) + "." + "expressionProviders";
        public static final String ATTR_CLASS = "class";
        public static final String ATTR_LANGUAGE = "language";
        public static final String ATTR_REQUIRES_MODEL_CLASS = "requiresModelClass";
        public static final String ATTR_NAME = "name";
        public static final String ATTR_DESCRIPTION = "description";
        public static final String ATTR_LOOSELY_TYPED = "isLooselyTyped";
        private IConfigurationElement configElement;
        private String language;
        private String className;
        private boolean modelReflection;
        private boolean isLooselyTyped;
        private String name;
        private String description;
        private IStatus status = Status.OK_STATUS;
        private IModelExpressionProvider provider;

        Descriptor(IConfigurationElement config) {
            try {
                this.configure(config);
            }
            catch (InvalidRegistryObjectException e) {
                GMFValidationPlugin.log(4, Messages.initDescriptorFailure, e);
            }
        }

        public IStatus getStatus() {
            return this.status;
        }

        public String getLanguage() {
            return this.language;
        }

        public boolean supportsModelReflection() {
            return this.modelReflection;
        }

        public boolean isLooselyTyped() {
            return this.isLooselyTyped;
        }

        public String getProviderClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        IModelExpressionProvider getProvider() {
            if (this.provider == null && this.getStatus().isOK()) {
                try {
                    this.provider = (IModelExpressionProvider)this.configElement.createExecutableExtension(ATTR_CLASS);
                }
                catch (CoreException e) {
                    String message = NLS.bind((String)Messages.providerCreationFailure, (Object)this.getProviderClassName());
                    GMFValidationPlugin.log(4, message, e);
                }
            }
            return this.provider;
        }

        private void configure(IConfigurationElement config) {
            this.configElement = config;
            this.language = this.configElement.getAttribute(ATTR_LANGUAGE);
            if (this.language == null || this.language.trim().length() == 0) {
                this.status = GMFValidationPlugin.createStatus(4, 0, Messages.missingProviderLanguage, null);
            }
            this.className = config.getAttribute(ATTR_CLASS);
            if (this.className == null || this.className.trim().length() == 0) {
                this.status = GMFValidationPlugin.createStatus(4, 0, Messages.missingProviderClass, null);
            }
            this.modelReflection = "true".equals(config.getAttribute(ATTR_REQUIRES_MODEL_CLASS));
            this.isLooselyTyped = "true".equals(config.getAttribute(ATTR_LOOSELY_TYPED));
            this.name = config.getAttribute(ATTR_NAME);
            this.description = config.getAttribute(ATTR_DESCRIPTION);
        }
    }
}

