/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.ConnectionBendpointTracker;
import org.eclipse.swt.SWT;

public class ConnectionBendpointTrackerEx
extends ConnectionBendpointTracker {
    private PrecisionRectangle sourceRectangle;
    private Point originalLocation = null;
    private final int MODIFIER_NO_SNAPPING = SWT.getPlatform().equals("carbon") ? 262144 : 65536;

    public ConnectionBendpointTrackerEx(ConnectionEditPart editpart, int i) {
        super(editpart, i);
    }

    protected void updateSourceRequest() {
        BendpointRequest request = (BendpointRequest)this.getSourceRequest();
        if (this.originalLocation == null) {
            this.originalLocation = this.getStartLocation().getCopy();
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        SnapToHelper snapToHelper = (SnapToHelper)this.getConnectionEditPart().getAdapter(SnapToHelper.class);
        Rectangle rect = new Rectangle(this.originalLocation.x, this.originalLocation.y, 1, 1);
        if (this.sourceRectangle == null) {
            this.sourceRectangle = new PrecisionRectangle(rect);
        }
        if (snapToHelper != null && !this.getCurrentInput().isModKeyDown(this.MODIFIER_NO_SNAPPING)) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            Point newLocation = this.originalLocation.getCopy().translate((Point)preciseDelta);
            request.setLocation(newLocation);
        } else {
            request.setLocation(this.getLocation());
        }
    }

    protected boolean handleDragStarted() {
        this.originalLocation = null;
        this.sourceRectangle = null;
        return super.handleDragStarted();
    }
}

