/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drop;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.DragDropListenerService;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.TransferAdapterService;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.DropTargetContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.ITransferDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.l10n.CommonUIServicesDNDMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;

public class DelegatingDropTargetAdapter
implements DropTargetListener {
    private ITransferDropTargetListener[] adapters = null;
    private ITransferDropTargetListener chosenAdapter = null;
    private final DropTargetContext context;
    private int origDropType = 0;
    private int currentDropType = 0;

    public DelegatingDropTargetAdapter(DropTargetContext aContext) {
        assert (aContext != null) : "context information for the drop target cannot be null";
        this.context = aContext;
        this.adapters = this.getAllTransferAdapters();
    }

    public void dragEnter(DropTargetEvent event) {
        try {
            this.setOrigDropType(event.detail);
            this.getContext().setCurrentTargetAndLocation(event);
            this.initAdapters();
            this.setChosenAdapter(event);
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dragEnter(event);
            } else {
                this.getContext().dragEnter(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragEnter::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragEnter::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            event.detail = 0;
            this.handle(e, false);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        try {
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dragLeave(event);
            } else {
                this.getContext().dragLeave(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragLeave::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragLeave::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            this.handle(e, false);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        try {
            this.setOrigDropType(event.detail);
            this.getContext().setCurrentTargetAndLocation(event);
            this.setChosenAdapter(event);
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dragOperationChanged(event);
            } else {
                this.getContext().dragOperationChanged(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragOperationChanged::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragOperationChanged::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            event.detail = 0;
            this.handle(e, false);
        }
    }

    public void dragOver(DropTargetEvent event) {
        try {
            this.getContext().setCurrentTargetAndLocation(event);
            event.detail = this.getOrigDropType();
            this.setChosenAdapter(event);
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dragOver(event);
                if (event.detail != 0) {
                    this.setCurrentDropType(event.detail);
                }
            } else {
                this.getContext().dragOver(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragOver::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragOver::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            event.detail = 0;
            this.handle(e, false);
        }
    }

    public void drop(DropTargetEvent event) {
        try {
            int oldDetail = event.detail;
            this.getContext().setCurrentTargetAndLocation(event);
            event.detail = this.getCurrentDropType();
            this.setChosenAdapter(event);
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().drop(event);
            } else {
                event.detail = oldDetail;
                this.getContext().drop(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("Drop::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("Drop::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            event.detail = 0;
            this.handle(e, true);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        try {
            int oldDetail = event.detail;
            this.getContext().setCurrentTargetAndLocation(event);
            event.detail = this.getCurrentDropType();
            this.setChosenAdapter(event);
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dropAccept(event);
                if (event.detail != this.getCurrentDropType()) {
                    this.setCurrentDropType(event.detail);
                }
            } else {
                event.detail = oldDetail;
                this.getContext().dropAccept(event);
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DropAccept::Event detail is " + event.detail));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DropAccept::Chosen adapter is " + adapterChosen));
            }
        }
        catch (Throwable e) {
            event.detail = 0;
            this.handle(e, false);
        }
    }

    private ITransferDropTargetListener[] getAdapters() {
        return this.adapters;
    }

    private DropTargetContext getContext() {
        return this.context;
    }

    public Transfer[] getAllTransferAgents() {
        if (this.getAdapters() == null || this.getAdapters().length == 0) {
            return null;
        }
        ArrayList<Transfer> list = new ArrayList<Transfer>();
        int i = 0;
        while (i < this.getAdapters().length) {
            list.add(this.getAdapters()[i].getTransferAgent().getTransfer());
            ++i;
        }
        return list.toArray(new Transfer[list.size()]);
    }

    private ITransferDropTargetListener[] getAllTransferAdapters() {
        ArrayList<ITransferDropTargetListener> listOfSupportedAdapters = new ArrayList<ITransferDropTargetListener>();
        String[] transferIds = DragDropListenerService.getInstance().getAllTransferIds(this.getContext().getActivePart().getSite().getId(), "drop");
        if (transferIds == null || transferIds.length == 0) {
            return null;
        }
        int i = 0;
        while (i < transferIds.length) {
            ITransferDropTargetListener adapter = TransferAdapterService.getInstance().getTransferDropTargetAdapter(transferIds[i]);
            if (adapter != null) {
                listOfSupportedAdapters.add(adapter);
            }
            ++i;
        }
        return !listOfSupportedAdapters.isEmpty() ? listOfSupportedAdapters.toArray(new ITransferDropTargetListener[listOfSupportedAdapters.size()]) : null;
    }

    private void setChosenAdapter(DropTargetEvent event) {
        this.chosenAdapter = null;
        TransferData[] dataTypes = event.dataTypes;
        if (dataTypes == null || dataTypes.length == 0) {
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)"setChosenAdapter::No transfer types available in the event");
            }
            return;
        }
        if (this.getAdapters() == null) {
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)"setChosenAdapter::No adapters registered with this target");
            }
            return;
        }
        if (this.getContext().getCurrentTarget() == null) {
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)"setChosenAdapter::Current target is null");
            }
            return;
        }
        int i = 0;
        while (i < this.getAdapters().length) {
            if (this.getAdapters()[i].getTransferAgent().isSelectionType() && this.getAdapters()[i].canSupport(event)) {
                this.chosenAdapter = this.getAdapters()[i];
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.getAdapters().length) {
            if (!this.getAdapters()[i].getTransferAgent().isSelectionType() && this.getAdapters()[i].canSupport(event)) {
                this.chosenAdapter = this.getAdapters()[i];
                return;
            }
            ++i;
        }
    }

    private ITransferDropTargetListener getChosenAdapter() {
        return this.chosenAdapter;
    }

    private void handle(Throwable exception, boolean displayDialog) {
        if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING)) {
            Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"handle", (Throwable)exception);
        }
        Status status = new Status(4, CommonUIServicesDNDPlugin.getPluginId(), 3, CommonUIServicesDNDMessages.DelegatingDropTargetAdapter__ERROR__errorMessage, exception);
        Log.log((Plugin)CommonUIServicesDNDPlugin.getDefault(), (IStatus)status);
        if (displayDialog) {
            status = new Status(4, CommonUIServicesDNDPlugin.getPluginId(), 3, CommonUIServicesDNDMessages.DelegatingDropTargetAdapter_errorMessage, exception);
            ErrorDialog.openError((Shell)this.getContext().getActivePart().getSite().getShell(), null, null, (IStatus)status);
        }
    }

    private int getOrigDropType() {
        return this.origDropType;
    }

    private void setOrigDropType(int anOrigDropType) {
        this.origDropType = anOrigDropType;
    }

    private int getCurrentDropType() {
        return this.currentDropType;
    }

    private void setCurrentDropType(int aCurrentDropType) {
        this.currentDropType = aCurrentDropType;
    }

    private void initAdapters() {
        if (this.getAdapters() != null) {
            int i = 0;
            while (i < this.getAdapters().length) {
                this.getAdapters()[i].init(this.getContext());
                ++i;
            }
        }
    }
}

