/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.NonResolvingResourceSet;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;

public class LoadingEMFResource
extends SerializationEMFResource {
    private final ResourceSet rset;
    private Map idToEObjectMapCopy;
    private Map eObjectToIDMapCopy;

    public LoadingEMFResource(ResourceSet rset, String encoding, Map defaultLoadOptions, IClipboardSupport clipboardOperationHelper) {
        super(encoding, clipboardOperationHelper);
        this.rset = rset;
        this.defaultLoadOptions = defaultLoadOptions;
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.throwUnsupportedOperationException("doSave", new UnsupportedOperationException("Can't call save on deserializing resource"));
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        NonResolvingResourceSet nonResolvingResourceSet = new NonResolvingResourceSet(this.rset);
        nonResolvingResourceSet.getResources().add((Object)this);
        IOException exception = null;
        try {
            super.doLoad(inputStream, options);
        }
        catch (IOException ex) {
            exception = ex;
        }
        nonResolvingResourceSet.getResources().remove((Object)this);
        this.getIDToEObjectMapCopy().putAll(this.getIDToEObjectMap());
        this.getEObjectToIDMapCopy().putAll(this.getEObjectToIDMap());
        if (exception != null) {
            throw exception;
        }
    }

    Map getIDToEObjectMapCopy() {
        if (this.idToEObjectMapCopy == null) {
            this.idToEObjectMapCopy = new HashMap();
        }
        return this.idToEObjectMapCopy;
    }

    Map getEObjectToIDMapCopy() {
        if (this.eObjectToIDMapCopy == null) {
            this.eObjectToIDMapCopy = new HashMap();
        }
        return this.eObjectToIDMapCopy;
    }

    protected void detachedHelper(EObject eObject) {
        super.detachedHelper(eObject);
        DETACHED_EOBJECT_TO_ID_MAP.remove(eObject);
    }
}

