/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.clipboard.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;

abstract class AbstractClipboardDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private Shell shell = null;
    private EXTLibraryEditor editor = null;
    private Collection selectedEObjects = Collections.EMPTY_SET;
    private Collection selectedResources = Collections.EMPTY_SET;

    protected AbstractClipboardDelegate() {
    }

    protected Collection getSelectedObjects() {
        return this.selectedEObjects;
    }

    protected Collection getSelectedResources() {
        return this.selectedResources;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void selectInEditor(Collection objects) {
        this.editor.setSelectionToViewer(objects);
    }

    protected EXTLibraryEditor getEditor() {
        return this.editor;
    }

    public final void run(IAction action) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            this.doRun(clipboard);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    protected abstract void doRun(Clipboard var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = Collections.EMPTY_SET;
        this.selectedResources = Collections.EMPTY_SET;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selectedEObjects = new ArrayList();
            this.selectedResources = new ArrayList();
            for (Object next : structuredSelection) {
                if (next instanceof EObject) {
                    this.selectedEObjects.add(next);
                    continue;
                }
                if (!(next instanceof Resource)) continue;
                this.selectedResources.add(next);
            }
        }
        action.setEnabled(!this.selectedEObjects.isEmpty());
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }
}

