/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class MultiplyAlphaRed
extends AbstractRed {
    public MultiplyAlphaRed(CachableRed cachableRed, CachableRed cachableRed2) {
        super(MultiplyAlphaRed.makeList(cachableRed, cachableRed2), MultiplyAlphaRed.makeBounds(cachableRed, cachableRed2), MultiplyAlphaRed.fixColorModel(cachableRed), MultiplyAlphaRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public boolean is_INT_PACK_BYTE_COMP(SampleModel sampleModel, SampleModel sampleModel2) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (!(sampleModel2 instanceof ComponentSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        if (sampleModel2.getDataType() != 0) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        if (nArray[3] != -16777216) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel2;
        if (componentSampleModel.getNumBands() != 1) {
            return false;
        }
        return componentSampleModel.getPixelStride() == 1;
    }

    public WritableRaster INT_PACK_BYTE_COMP_Impl(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        cachableRed.copyData(writableRaster);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        Raster raster = cachableRed2.getData(rectangle);
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = componentSampleModel.getScanlineStride();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n2 = dataBufferByte.getOffset() + componentSampleModel.getOffset(rectangle.x - raster.getSampleModelTranslateX(), rectangle.y - raster.getSampleModelTranslateY());
        byte[] byArray = dataBufferByte.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(rectangle.x - writableRaster.getSampleModelTranslateX(), rectangle.y - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.isAlphaPremultiplied()) {
            int n5 = 0;
            while (n5 < rectangle.height) {
                int n6 = n4 + n5 * n3;
                int n7 = n2 + n5 * n;
                int n8 = n6 + rectangle.width;
                while (n6 < n8) {
                    int n9 = byArray[n7++] & 0xFF;
                    int n10 = nArray[n6];
                    nArray[n6] = ((n10 >>> 24) * n9 & 0xFF00) << 16 | ((n10 >>> 16 & 0xFF) * n9 & 0xFF00) << 8 | (n10 >>> 8 & 0xFF) * n9 & 0xFF00 | ((n10 & 0xFF) * n9 & 0xFF00) >> 8;
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n11 = 0;
            while (n11 < rectangle.height) {
                int n12 = n4 + n11 * n3;
                int n13 = n2 + n11 * n;
                int n14 = n12 + rectangle.width;
                while (n12 < n14) {
                    int n15 = byArray[n13++] & 0xFF;
                    int n16 = nArray[n12] >>> 24;
                    nArray[n12] = (n16 * n15 & 0xFF00) << 16 | nArray[n12] & 0xFFFFFF;
                    ++n12;
                }
                ++n11;
            }
        }
        return writableRaster;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        if (this.is_INT_PACK_BYTE_COMP(cachableRed.getSampleModel(), cachableRed2.getSampleModel())) {
            return this.INT_PACK_BYTE_COMP_Impl(writableRaster);
        }
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            cachableRed.copyData(writableRaster);
            Rectangle rectangle = writableRaster.getBounds();
            if (!rectangle.intersects(cachableRed2.getBounds())) {
                return writableRaster;
            }
            rectangle = rectangle.intersection(cachableRed2.getBounds());
            int[] nArray = null;
            int[] nArray2 = null;
            Raster raster = cachableRed2.getData(rectangle);
            int n = rectangle.width;
            int n2 = writableRaster.getSampleModel().getNumBands();
            if (colorModel.isAlphaPremultiplied()) {
                int n3 = rectangle.y;
                while (n3 < rectangle.y + rectangle.height) {
                    nArray = writableRaster.getPixels(rectangle.x, n3, n, 1, nArray);
                    nArray2 = raster.getSamples(rectangle.x, n3, n, 1, 0, nArray2);
                    int n4 = 0;
                    switch (n2) {
                        case 2: {
                            int n5;
                            int n6 = 0;
                            while (n6 < nArray2.length) {
                                n5 = nArray2[n6] & 0xFF;
                                nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                ++n4;
                                ++n6;
                            }
                            break;
                        }
                        case 4: {
                            int n5;
                            int n7 = 0;
                            while (n7 < nArray2.length) {
                                n5 = nArray2[n7] & 0xFF;
                                nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                ++n4;
                                ++n7;
                            }
                            break;
                        }
                        default: {
                            int n5;
                            int n8 = 0;
                            while (n8 < nArray2.length) {
                                n5 = nArray2[n8] & 0xFF;
                                int n9 = 0;
                                while (n9 < n2) {
                                    nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                    ++n4;
                                    ++n9;
                                }
                                ++n8;
                            }
                            break block0;
                        }
                    }
                    writableRaster.setPixels(rectangle.x, n3, n, 1, nArray);
                    ++n3;
                }
            } else {
                int n10 = cachableRed.getSampleModel().getNumBands() - 1;
                int n11 = rectangle.y;
                while (n11 < rectangle.y + rectangle.height) {
                    nArray = writableRaster.getSamples(rectangle.x, n11, n, 1, n10, nArray);
                    nArray2 = raster.getSamples(rectangle.x, n11, n, 1, 0, nArray2);
                    int n12 = 0;
                    while (n12 < nArray.length) {
                        nArray[n12] = (nArray[n12] & 0xFF) * (nArray2[n12] & 0xFF) >> 8;
                        ++n12;
                    }
                    writableRaster.setSamples(rectangle.x, n11, n, 1, n10, nArray);
                    ++n11;
                }
            }
            return writableRaster;
        }
        int[] nArray = new int[writableRaster.getNumBands() - 1];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = n;
            ++n;
        }
        WritableRaster writableRaster2 = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), nArray);
        cachableRed.copyData(writableRaster2);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        nArray = new int[]{writableRaster.getNumBands() - 1};
        writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray);
        cachableRed2.copyData(writableRaster2);
        return writableRaster;
    }

    public static List makeList(CachableRed cachableRed, CachableRed cachableRed2) {
        ArrayList<CachableRed> arrayList = new ArrayList<CachableRed>(2);
        arrayList.add(cachableRed);
        arrayList.add(cachableRed2);
        return arrayList;
    }

    public static Rectangle makeBounds(CachableRed cachableRed, CachableRed cachableRed2) {
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed2.getBounds();
        return rectangle.intersection(rectangle2);
    }

    public static SampleModel fixSampleModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (colorModel.hasAlpha()) {
            return sampleModel;
        }
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        int n3 = sampleModel.getNumBands() + 1;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n4;
            ++n4;
        }
        return new PixelInterleavedSampleModel(0, n, n2, n3, n * n3, nArray);
    }

    public static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            return colorModel;
        }
        int n = cachableRed.getSampleModel().getNumBands() + 1;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 8;
            ++n2;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
    }
}

