/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionLabelsEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractBorderedShapeEditPart
extends ShapeNodeEditPart
implements IBorderedShapeEditPart {
    public AbstractBorderedShapeEditPart(View view) {
        super(view);
    }

    public IFigure getMainFigure() {
        return this.getBorderedFigure().getMainFigure();
    }

    public final BorderedNodeFigure getBorderedFigure() {
        return (BorderedNodeFigure)this.getFigure();
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPaneFor((IGraphicalEditPart)child).setConstraint(childFigure, constraint);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getMainFigure();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure childFigure = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof IBorderItemEditPart) {
            IFigure borderItemContainer = this.getContentPaneFor((IGraphicalEditPart)childEditPart);
            this.addBorderItem(borderItemContainer, (IBorderItemEditPart)childEditPart);
        } else {
            IFigure parent = this.getContentPaneFor((IGraphicalEditPart)childEditPart);
            index = Math.min(parent.getChildren().size(), index);
            parent.add(childFigure, index);
        }
    }

    protected void reorderChild(EditPart child, int index) {
        if (child instanceof IBorderItemEditPart) {
            IFigure childFigure = ((GraphicalEditPart)child).getFigure();
            LayoutManager layout = this.getContentPaneFor((IGraphicalEditPart)child).getLayoutManager();
            Object constraint = null;
            if (layout != null) {
                constraint = layout.getConstraint(childFigure);
            }
            super.reorderChild(child, index);
            this.setLayoutConstraint(child, childFigure, constraint);
        } else {
            super.reorderChild(child, index);
        }
    }

    protected void removeChildVisual(EditPart child) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        IFigure fig = this.getContentPaneFor((IGraphicalEditPart)child);
        fig.remove(childFigure);
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        borderItemContainer.add(borderItemEditPart.getFigure(), (Object)new BorderItemLocator(this.getMainFigure()));
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ConnectionLabelsEditPolicy());
    }

    protected NodeFigure createNodeFigure() {
        return new BorderedNodeFigure((IFigure)this.createMainFigure());
    }

    protected abstract NodeFigure createMainFigure();
}

