/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BitmapHelper;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class StretchDIBits
implements IWmf2SvgConverter,
IEmf2SvgConverter {
    private static final int EMF_XDEST_OFFSET = 16;
    private static final int EMF_YDEST_OFFSET = 20;
    private static final int EMF_XSRC_OFFSET = 24;
    private static final int EMF_YSRC_OFFSET = 28;
    private static final int EMF_WSRC_OFFSET = 32;
    private static final int EMF_HSRC_OFFSET = 36;
    private static final int EMF_BMI_OFFSET_OFFSET = 40;
    private static final int EMF_BMI_SIZE_OFFSET = 44;
    private static final int EMF_DATA_OFFSET_OFFSET = 48;
    private static final int EMF_DATA_SIZE_OFFSET = 52;
    private static final int EMF_WDEST_OFFSET = 64;
    private static final int EMF_HDEST_OFFSET = 68;
    private static final int WMF_XDEST_OFFSET = 18;
    private static final int WMF_YDEST_OFFSET = 16;
    private static final int WMF_WDEST_OFFSET = 14;
    private static final int WMF_HDEST_OFFSET = 12;
    private static final int WMF_XSRC_OFFSET = 10;
    private static final int WMF_YSRC_OFFSET = 8;
    private static final int WMF_WSRC_OFFSET = 6;
    private static final int WMF_HSRC_OFFSET = 4;
    private static final int WMF_BMI_OFFSET = 20;
    protected int m_xDest = 0;
    protected int m_yDest = 0;
    protected int m_wDest = 0;
    protected int m_hDest = 0;
    protected int m_xSrc = 0;
    protected int m_ySrc = 0;
    protected int m_wSrc = 0;
    protected int m_hSrc = 0;
    protected BufferedImage m_image = null;

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        this.m_xDest = rec.getShortAt(18);
        this.m_yDest = rec.getShortAt(16);
        this.m_wDest = rec.getShortAt(14);
        this.m_hDest = rec.getShortAt(12);
        this.m_xSrc = rec.getShortAt(10);
        this.m_ySrc = rec.getShortAt(8);
        this.m_wSrc = rec.getShortAt(6);
        this.m_hSrc = rec.getShortAt(4);
        int bmiSize = BitmapHelper.getHeaderSize(rec, 20, 0);
        int dataOffset = 20 + bmiSize;
        int dataSize = rec.getSize() - dataOffset;
        this.m_image = BitmapHelper.readBitmap(rec, 20, bmiSize, dataOffset, dataSize);
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        this.m_xDest = rec.getIntAt(16);
        this.m_yDest = rec.getIntAt(20);
        this.m_wDest = rec.getIntAt(64);
        this.m_hDest = rec.getIntAt(68);
        this.m_xSrc = rec.getIntAt(24);
        this.m_ySrc = rec.getIntAt(28);
        this.m_wSrc = rec.getIntAt(32);
        this.m_hSrc = rec.getIntAt(36);
        int bmiOffset = rec.getIntAt(40) - 8;
        int bmiSize = rec.getIntAt(44);
        int dataOffset = rec.getIntAt(48) - 8;
        int dataSize = rec.getIntAt(52);
        this.m_image = BitmapHelper.readBitmap(rec, bmiOffset, bmiSize, dataOffset, dataSize);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        int w = this.m_image.getWidth();
        int h = this.m_image.getHeight();
        int xDest = context.convertXToSVGLogicalUnits(this.m_xDest);
        int yDest = context.convertYToSVGLogicalUnits(this.m_yDest);
        int wDest = context.scaleX(this.m_wDest);
        int hDest = context.scaleY(this.m_hDest);
        if (this.m_xSrc >= w || this.m_ySrc >= h) {
            return;
        }
        if (this.m_xSrc + this.m_wSrc > w) {
            this.m_wSrc = w - this.m_xSrc;
        }
        if (this.m_ySrc + this.m_hSrc > h) {
            this.m_hSrc = h - this.m_ySrc;
        }
        BufferedImage image = this.m_image.getSubimage(this.m_xSrc, this.m_ySrc, this.m_wSrc, this.m_hSrc);
        double scaleFactorX = (double)wDest / (double)this.m_wSrc;
        double scaleFactorY = (double)hDest / (double)this.m_hSrc;
        AffineTransform xform = new AffineTransform();
        xform.translate(xDest, yDest);
        xform.scale(scaleFactorX, scaleFactorY);
        g.drawImage(image, xform, null);
    }
}

