/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;

public class FileUtil {
    private static final String RELATIVE_STR = "..";

    public static void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"createFile", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)"createFile", (Throwable)e);
            Trace.throwing((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"createFile", (Throwable)e);
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void deleteFile(IFile fileHandle, IProgressMonitor monitor) throws CoreException {
        try {
            fileHandle.delete(true, monitor);
        }
        catch (CoreException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"createFile", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)"createFile", (Throwable)e);
            Trace.throwing((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"createFile", (Throwable)e);
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static String getRelativePath(String urlPathstr, String modelPathstr) {
        StringBuffer res = new StringBuffer();
        Path urlPath = new Path(urlPathstr);
        Path modelPath = new Path(modelPathstr);
        if (urlPathstr.indexOf("://") > 0) {
            return urlPathstr;
        }
        int matchingSegments = urlPath.matchingFirstSegments((IPath)modelPath);
        int backSegments = modelPath.segmentCount() - matchingSegments - 1;
        while (backSegments > 0) {
            res.append(RELATIVE_STR);
            res.append(File.separatorChar);
            --backSegments;
        }
        int segCount = urlPath.segmentCount();
        int i = matchingSegments;
        while (i < segCount) {
            if (i > matchingSegments) {
                res.append(File.separatorChar);
            }
            res.append(urlPath.segment(i));
            ++i;
        }
        return res.toString();
    }

    public static String getAbsolutePath(String strurlPath, String strmodelPath) {
        Path urlPath = new Path(strurlPath);
        if (urlPath.isAbsolute()) {
            return strurlPath;
        }
        Path modelPath = new Path(strmodelPath);
        int rel_level = 0;
        int i = 0;
        while (i < urlPath.segmentCount()) {
            if (urlPath.segment(i).equals(RELATIVE_STR)) {
                ++rel_level;
            }
            ++i;
        }
        urlPath = urlPath.removeFirstSegments(rel_level);
        modelPath = modelPath.removeLastSegments(rel_level + 1);
        urlPath = modelPath.append((IPath)urlPath);
        return urlPath.toOSString();
    }
}

