/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.DecoratorService;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ImageFigureEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.OnConnectionLocator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.RelativeToBorderLocator;
import org.eclipse.swt.graphics.Image;

public class DecorationEditPolicy
extends GraphicalEditPolicyEx {
    protected Map decorators;

    public void refresh() {
        if (this.decorators == null) {
            this.decorators = new HashMap();
            DecoratorService.getInstance().createDecorators(new DecoratorTarget());
        }
        for (IDecorator decorator : this.decorators.values()) {
            decorator.refresh();
        }
    }

    public void activate() {
        if (this.decorators == null) {
            this.decorators = new HashMap();
            DecoratorService.getInstance().createDecorators(new DecoratorTarget());
        }
        if (this.decorators != null) {
            for (IDecorator decorator : this.decorators.values()) {
                decorator.activate();
            }
        }
    }

    public void deactivate() {
        if (this.decorators != null) {
            for (IDecorator decorator : this.decorators.values()) {
                decorator.deactivate();
            }
        }
    }

    protected final Map getDecorators() {
        return this.decorators;
    }

    protected final void setDecorators(Map decorators) {
        this.decorators = decorators;
    }

    public int getPositionConstant(IDecoratorTarget.Direction direction) {
        if (direction == IDecoratorTarget.Direction.CENTER) {
            return 2;
        }
        if (direction == IDecoratorTarget.Direction.NORTH) {
            return 1;
        }
        if (direction == IDecoratorTarget.Direction.SOUTH) {
            return 4;
        }
        if (direction == IDecoratorTarget.Direction.WEST) {
            return 8;
        }
        if (direction == IDecoratorTarget.Direction.EAST) {
            return 16;
        }
        if (direction == IDecoratorTarget.Direction.NORTH_EAST) {
            return 17;
        }
        if (direction == IDecoratorTarget.Direction.NORTH_WEST) {
            return 9;
        }
        if (direction == IDecoratorTarget.Direction.SOUTH_EAST) {
            return 20;
        }
        if (direction == IDecoratorTarget.Direction.SOUTH_WEST) {
            return 12;
        }
        return 2;
    }

    public class DecoratorTarget
    implements IDecoratorTarget {
        @Override
        public void installDecorator(Object key, IDecorator decorator) {
            Assert.isNotNull((Object)key, (String)"Decorators must be installed with keys");
            DecorationEditPolicy.this.decorators.put(key, decorator);
        }

        public Object getAdapter(Class adapter) {
            return DecorationEditPolicy.this.getHost().getAdapter(adapter);
        }

        @Override
        public IDecoration addShapeDecoration(Image image, IDecoratorTarget.Direction direction, int margin, boolean isVolatile) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)DecorationEditPolicy.this.getHost().getFigure());
            ImageFigureEx figure = new ImageFigureEx();
            figure.setImage(image);
            figure.setSize(mm.DPtoLP(image.getBounds().width), mm.DPtoLP(image.getBounds().height));
            return this.addShapeDecoration((IFigure)figure, direction, margin, isVolatile);
        }

        @Override
        public IDecoration addConnectionDecoration(Image image, int percentageFromSource, boolean isVolatile) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)DecorationEditPolicy.this.getHost().getFigure());
            ImageFigureEx figure = new ImageFigureEx();
            figure.setImage(image);
            figure.setSize(mm.DPtoLP(image.getBounds().width), mm.DPtoLP(image.getBounds().height));
            return this.addConnectionDecoration((IFigure)figure, percentageFromSource, isVolatile);
        }

        @Override
        public void removeDecoration(IDecoration decoration) {
            if (decoration instanceof IFigure) {
                ((IFigure)decoration).getParent().remove((IFigure)decoration);
            }
            GraphicalEditPart ownerEditPart = (GraphicalEditPart)this.getAdapter(GraphicalEditPart.class);
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }

        @Override
        public IDecoration addShapeDecoration(IFigure figure, IDecoratorTarget.Direction direction, int margin, boolean isVolatile) {
            return this.addDecoration(figure, (Locator)new RelativeToBorderLocator(((GraphicalEditPart)this.getAdapter(GraphicalEditPart.class)).getFigure(), DecorationEditPolicy.this.getPositionConstant(direction), margin), isVolatile);
        }

        @Override
        public IDecoration addConnectionDecoration(IFigure figure, int percentageFromSource, boolean isVolatile) {
            IFigure hostFigure = ((GraphicalEditPart)this.getAdapter(GraphicalEditPart.class)).getFigure();
            Assert.isTrue((boolean)(hostFigure instanceof Connection));
            return this.addDecoration(figure, (Locator)new OnConnectionLocator((Connection)hostFigure, percentageFromSource), isVolatile);
        }

        @Override
        public IDecoration addDecoration(IFigure figure, Locator locator, boolean isVolatile) {
            Decoration decoration = new Decoration();
            decoration.add(figure);
            decoration.setSize(figure.getSize());
            GraphicalEditPart ownerEditPart = (GraphicalEditPart)this.getAdapter(GraphicalEditPart.class);
            decoration.setOwnerFigure(ownerEditPart.getFigure());
            decoration.setLocator(locator);
            ownerEditPart.getViewer().getVisualPartMap().put(decoration, ownerEditPart);
            IFigure pane = DecorationEditPolicy.this.getLayer(isVolatile ? "Decoration Unprintable Layer" : "Decoration Printable Layer");
            pane.add((IFigure)decoration);
            return decoration;
        }
    }
}

