/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.common.core.util.EnumeratedType;

public class ImageFileFormat
extends EnumeratedType {
    private static final int IMAGE_SVG = 100;
    private static final int IMAGE_PDF = 101;
    static final long serialVersionUID = 1L;
    public static final float DEFAULT_QUALITY = 1.0f;
    public static final ImageFileFormat GIF = new ImageFileFormat("GIF", 2);
    public static final ImageFileFormat JPEG = new ImageFileFormat("JPEG", 4);
    public static final ImageFileFormat JPG = new ImageFileFormat("JPG", 4);
    public static final ImageFileFormat BMP = new ImageFileFormat("BMP", 0);
    public static final ImageFileFormat SVG = new ImageFileFormat("SVG", 100);
    public static final ImageFileFormat PDF = new ImageFileFormat("PDF", 101);
    public static final ImageFileFormat PNG = new ImageFileFormat("PNG", 5);
    public static final ImageFileFormat[] VALUES = new ImageFileFormat[]{GIF, BMP, JPEG, JPG, SVG, PNG, PDF};
    private float quality = 1.0f;

    private ImageFileFormat(String name, int ordinal) {
        super(name, ordinal);
    }

    protected List getValues() {
        return Collections.unmodifiableList(Arrays.asList(VALUES));
    }

    public static ImageFileFormat getDefaultImageFormat() {
        return PNG;
    }

    public static ImageFileFormat resolveImageFormat(int ordinal) {
        return VALUES[ordinal];
    }

    public static ImageFileFormat resolveImageFormat(String imageFormat) {
        int i = 0;
        while (i < VALUES.length) {
            if (VALUES[i].getName().toLowerCase().equals(imageFormat.toLowerCase())) {
                return VALUES[i];
            }
            ++i;
        }
        return ImageFileFormat.getDefaultImageFormat();
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }
}

