/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.preferences;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.eclipse.gmf.runtime.common.ui.preferences.AbstractPreferencePage;
import org.eclipse.gmf.runtime.common.ui.preferences.ComboFieldEditor;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RulerGridPreferencePage
extends AbstractPreferencePage {
    private int oldUnits = -1;
    private static final int INCHES = 0;
    private static final int CENTIMETERS = 1;
    private static final int PIXELS = 2;
    private static final double INCH2CM = 2.54;
    private String RULER_GROUP_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerGroup_label;
    private String SHOW_RULERS_LABEL = DiagramUIMessages.GridRulerPreferencePage_showRulers_label;
    private String RULER_UNITS_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_label;
    private String RULER_UNITS_IN_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_inch_label;
    private String RULER_UNITS_CM_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_cm_label;
    private String RULER_UNITS_PIXEL_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_pixel_label;
    private String GRID_GROUP_LABEL = DiagramUIMessages.GridRulerPreferencePage_gridGroup_label;
    private String SHOW_GRID_LABEL = DiagramUIMessages.GridRulerPreferencePage_showGrid_label;
    private String SNAP_TO_GRID_LABEL = DiagramUIMessages.GridRulerPreferencePage_snapToGrid_label;
    private String SNAP_TO_GEOMETRY_LABEL = DiagramUIMessages.GridRulerPreferencePage_snapToGeometry_label;
    private String GRID_SPACING_LABEL_INCHES = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_inches;
    private String GRID_SPACING_LABEL_CM = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_cm;
    private String GRID_SPACING_LABEL_PIXELS = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_pixels;
    private BooleanFieldEditor showRulers = null;
    private ComboFieldEditor rulerUnits;
    private BooleanFieldEditor showGrid = null;
    private BooleanFieldEditor snapToGrid = null;
    private BooleanFieldEditor snapToGeometry = null;
    private DoubleFieldEditor gridSpacing = null;
    private Composite dblGroup = null;

    private String convertUnits(int fromUnits, int toUnits) {
        String valueStr = this.gridSpacing.getStringValue();
        if (fromUnits == toUnits) {
            return valueStr;
        }
        NumberFormat numberFormatter = NumberFormat.getInstance();
        Double value = 0.125;
        try {
            value = this.forceDouble(numberFormatter.parse(valueStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double pixelValue = 0.0;
        Display display = this.getControl().getDisplay();
        switch (fromUnits) {
            case 0: {
                pixelValue = value * (double)display.getDPI().x;
                break;
            }
            case 1: {
                pixelValue = value * (double)display.getDPI().x / 2.54;
                break;
            }
            case 2: {
                pixelValue = value.intValue();
            }
        }
        double returnValue = 0.0;
        switch (toUnits) {
            case 0: {
                returnValue = pixelValue / (double)display.getDPI().x;
                break;
            }
            case 1: {
                returnValue = pixelValue * 2.54 / (double)display.getDPI().x;
                break;
            }
            case 2: {
                returnValue = pixelValue;
            }
        }
        return numberFormatter.format(returnValue);
    }

    private double convertToBase(double number) {
        double returnValue = 0.0;
        switch (this.getUnits()) {
            case 0: {
                returnValue = number;
                break;
            }
            case 1: {
                returnValue = number / 2.54;
                break;
            }
            case 2: {
                returnValue = number / (double)this.getControl().getDisplay().getDPI().x;
            }
        }
        return returnValue;
    }

    private void updateUnits() {
        int units = this.getUnits();
        switch (units) {
            case 0: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_INCHES);
                break;
            }
            case 1: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_CM);
                break;
            }
            case 2: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_PIXELS);
            }
        }
        this.gridSpacing.setStringValue(this.convertUnits(this.oldUnits, units));
        this.oldUnits = units;
        this.dblGroup.layout();
    }

    private int getUnits() {
        int units = this.rulerUnits.getComboControl().getSelectionIndex();
        if (units == -1) {
            this.oldUnits = units = this.getPreferenceStore().getInt("GridRuler.rulerUnits");
        }
        return units;
    }

    private void addRulerFields(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.RULER_GROUP_LABEL);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.showRulers = new BooleanFieldEditor("GridRuler.showRulers", this.SHOW_RULERS_LABEL, (Composite)group);
        this.addField((FieldEditor)this.showRulers);
        this.rulerUnits = new ComboFieldEditor("GridRuler.rulerUnits", this.RULER_UNITS_LABEL, (Composite)group, 1, false, 0, 0, true);
        this.addField((FieldEditor)this.rulerUnits);
        Combo rulerUnitsCombo = this.rulerUnits.getComboControl();
        rulerUnitsCombo.add(this.RULER_UNITS_IN_LABEL);
        rulerUnitsCombo.add(this.RULER_UNITS_CM_LABEL);
        rulerUnitsCombo.add(this.RULER_UNITS_PIXEL_LABEL);
        rulerUnitsCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RulerGridPreferencePage.this.updateUnits();
            }
        });
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
    }

    private void addGridFields(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.GRID_GROUP_LABEL);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.showGrid = new BooleanFieldEditor("GridRuler.showGrid", this.SHOW_GRID_LABEL, (Composite)group);
        this.addField((FieldEditor)this.showGrid);
        this.snapToGrid = new BooleanFieldEditor("GridRuler.snapToGrid", this.SNAP_TO_GRID_LABEL, (Composite)group);
        this.addField((FieldEditor)this.snapToGrid);
        this.snapToGeometry = new BooleanFieldEditor("GridRuler.snapToGeometry", this.SNAP_TO_GEOMETRY_LABEL, (Composite)group);
        this.addField((FieldEditor)this.snapToGeometry);
        this.addGridSpacing((Composite)group);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
    }

    private void addGridSpacing(Composite parent) {
        this.dblGroup = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.gridSpacing = new DoubleFieldEditor("GridRuler.gridSpacing", this.GRID_SPACING_LABEL_INCHES, this.dblGroup);
        this.gridSpacing.setTextLimit(10);
        this.addField((FieldEditor)this.gridSpacing);
        this.updateUnits();
        this.dblGroup.setLayoutData((Object)gridData);
        this.dblGroup.setLayout((Layout)gridLayout);
    }

    protected void addFields(Composite parent) {
        this.addRulerFields(parent);
        this.addGridFields(parent);
    }

    protected void initHelp() {
    }

    public static void initDefaults(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("GridRuler.showRulers", false);
        String defaultCountry = Locale.getDefault().getCountry();
        if (defaultCountry == null || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry())) {
            preferenceStore.setDefault("GridRuler.rulerUnits", 0);
        } else {
            preferenceStore.setDefault("GridRuler.rulerUnits", 1);
        }
        preferenceStore.setDefault("GridRuler.showGrid", false);
        preferenceStore.setDefault("GridRuler.snapToGrid", true);
        preferenceStore.setDefault("GridRuler.snapToGeometry", false);
        preferenceStore.setDefault("GridRuler.gridSpacing", 0.125);
    }

    private Double forceDouble(Number number) {
        if (!(number instanceof Double)) {
            return number.doubleValue();
        }
        return (Double)number;
    }

    private class DoubleFieldEditor
    extends StringFieldEditor {
        private double minValidValue;
        private double maxValidValue;

        public DoubleFieldEditor(String pref, String label, Composite parent) {
            super(pref, label, parent);
            this.minValidValue = 0.009;
            this.maxValidValue = 99.999;
        }

        protected boolean doCheckState() {
            block6: {
                Number parsedNumber;
                ParsePosition parsePosition;
                Text text;
                block5: {
                    text = this.getTextControl();
                    if (text == null) {
                        return false;
                    }
                    try {
                        NumberFormat numberFormatter = NumberFormat.getInstance();
                        parsePosition = new ParsePosition(0);
                        parsedNumber = numberFormatter.parse(text.getText(), parsePosition);
                        if (parsedNumber != null) break block5;
                        this.showErrorMessage();
                        return false;
                    }
                    catch (NumberFormatException e1) {
                        this.showErrorMessage();
                        return false;
                    }
                }
                Double pageHeight = RulerGridPreferencePage.this.forceDouble(parsedNumber);
                double number = pageHeight;
                number = RulerGridPreferencePage.this.convertToBase(number);
                if (!(number >= this.minValidValue) || !(number <= this.maxValidValue) || parsePosition.getIndex() != text.getText().length()) break block6;
                this.clearErrorMessage();
                return true;
            }
            this.showErrorMessage();
            return false;
        }

        protected void doLoadDefault() {
            Text text = this.getTextControl();
            if (text != null) {
                double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
                NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                text.setText(numberFormatter.format(value));
            }
            this.valueChanged();
        }

        protected void doLoad() {
            Text text = this.getTextControl();
            if (text != null) {
                double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
                NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                text.setText(numberFormatter.format(value));
            }
        }

        protected void doStore() {
            NumberFormat numberFormatter = NumberFormat.getInstance();
            try {
                Double gridWidth = RulerGridPreferencePage.this.forceDouble(numberFormatter.parse(this.getTextControl().getText()));
                this.getPreferenceStore().setValue(this.getPreferenceName(), gridWidth.doubleValue());
            }
            catch (ParseException e) {
                this.showErrorMessage();
            }
        }
    }
}

