/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.util;

import java.util.Iterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EditPartUtil {
    public static String getSemanticEClassName(IGraphicalEditPart editPart) {
        if (editPart.getModel() instanceof View) {
            View view = (View)editPart.getModel();
            EObject element = view.getElement();
            return element == null ? null : PackageUtil.getID((ENamedElement)EMFCoreUtil.getProxyClass((EObject)element));
        }
        return null;
    }

    public static void removeCanonicalEditPolicies(EditPart editPart, boolean considerChildren) {
        EditPolicy ep = editPart.getEditPolicy((Object)"Canonical");
        if (ep != null) {
            editPart.removeEditPolicy((Object)ep);
        }
        if (considerChildren) {
            Iterator childrenIterator = editPart.getChildren().iterator();
            EditPartUtil.removeCanonicalEditPolicies(childrenIterator);
            if (editPart instanceof AbstractGraphicalEditPart) {
                AbstractGraphicalEditPart gEP = (AbstractGraphicalEditPart)editPart;
                Iterator sourceConnectionsIterator = gEP.getSourceConnections().iterator();
                EditPartUtil.removeCanonicalEditPolicies(sourceConnectionsIterator);
                Iterator targetConnectionsIterator = gEP.getTargetConnections().iterator();
                EditPartUtil.removeCanonicalEditPolicies(targetConnectionsIterator);
            }
        }
    }

    private static void removeCanonicalEditPolicies(Iterator childrenIterator) {
        while (childrenIterator.hasNext()) {
            EditPart child = (EditPart)childrenIterator.next();
            EditPartUtil.removeCanonicalEditPolicies(child, true);
        }
    }

    public static void synchronizeRunnableToMainThread(IGraphicalEditPart editPart, Runnable runThreadSafe) {
        InternalTransactionalEditingDomain editingDomain = (InternalTransactionalEditingDomain)editPart.getEditingDomain();
        if (Display.getCurrent() == null && editingDomain != null && editingDomain.getActiveTransaction() != null) {
            Display display = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getDefault();
            display.syncExec((Runnable)editingDomain.createPrivilegedRunnable(runThreadSafe));
        } else {
            runThreadSafe.run();
        }
    }

    public static boolean isWriteTransactionInProgress(IGraphicalEditPart editPart, boolean includeUnprotected, boolean otherThread) {
        InternalTransactionalEditingDomain internalEditingDomain;
        InternalTransaction transaction;
        TransactionalEditingDomain theEditingDomain = editPart.getEditingDomain();
        if (theEditingDomain instanceof InternalTransactionalEditingDomain && (transaction = (internalEditingDomain = (InternalTransactionalEditingDomain)theEditingDomain).getActiveTransaction()) != null && !transaction.isReadOnly()) {
            Object unprotectedMode;
            if (!includeUnprotected && Boolean.TRUE.equals(unprotectedMode = transaction.getOptions().get("unprotected"))) {
                return false;
            }
            if (otherThread && Thread.currentThread() != transaction.getOwner()) {
                return true;
            }
            if (!otherThread) {
                return true;
            }
        }
        return false;
    }
}

