/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.internal.commands;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ClipboardCommand;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.l10n.DiagramUIRenderMessages;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;

public class CopyImageCommand
extends AbstractCommand {
    private final List source;
    private DiagramEditPart diagramEP;
    public static final String DRAWING_SURFACE = "Drawing Surface";
    private final View viewContext;

    public CopyImageCommand(View viewContext, List source, DiagramEditPart diagramEP) {
        this(null, viewContext, source, diagramEP);
    }

    public CopyImageCommand(String label, View viewContext, List source, DiagramEditPart diagramEP) {
        super(label, null);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)viewContext);
        this.source = source;
        this.viewContext = viewContext;
        this.diagramEP = diagramEP;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        boolean imageCopyDiagram = false;
        if (this.getSource() == null || this.getSource().size() == 0) {
            imageCopyDiagram = true;
        }
        Map epRegistry = this.diagramEP.getViewer().getEditPartRegistry();
        ArrayList editParts = new ArrayList(this.getSource().size());
        ListIterator li = this.getSource().listIterator();
        while (li.hasNext()) {
            editParts.add(epRegistry.get(li.next()));
        }
        DiagramImageGenerator imageGenerator = new DiagramImageGenerator(this.getDiagramEditPart());
        Image image = null;
        try {
            image = imageCopyDiagram ? imageGenerator.createAWTImageForDiagram() : imageGenerator.createAWTImageForParts(editParts);
        }
        catch (OutOfMemoryError error) {
            String eMsg = DiagramUIRenderMessages.CopyAction_UnableToCopyImageMessage;
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)eMsg, (Throwable)error);
            MessageDialog.openInformation(null, (String)DiagramUIRenderMessages.CopyAction_ErrorDialogTitle, (String)eMsg);
        }
        CustomData data = null;
        if (!imageCopyDiagram) {
            data = this.getViewContext() != null ? new CustomData(DRAWING_SURFACE, ClipboardCommand.copyViewsToString((List)this.getSource()).getBytes()) : null;
        }
        AWTClipboardHelper.getInstance().copyToClipboard(data, image);
        this.diagramEP = null;
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        UnsupportedOperationException uoe = new UnsupportedOperationException();
        Trace.throwing((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"doRedoWithResult", (Throwable)uoe);
        throw uoe;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        UnsupportedOperationException uoe = new UnsupportedOperationException();
        Trace.throwing((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"doUndoWithResult", (Throwable)uoe);
        throw uoe;
    }

    private DiagramEditPart getDiagramEditPart() {
        return this.diagramEP;
    }

    private List getSource() {
        return this.source;
    }

    private View getViewContext() {
        return this.viewContext;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

