/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorReferenceType;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.internal.codegen.util.GenModelGraphAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelGraphAnalyzerTest
extends TestCase {
    private static final String ECLASS_NAME_PREFIX = "EClass";
    private GenTopLevelNode myStartNode;
    private GenNodeLabel myStartNodeLabel;
    private GenCompartment myStartNodeCompartment;
    private GenDiagram myDiagram;
    private EPackage myDomainModelPackage;
    private GenPackage myDomainModelGenPackage;
    private int myClassCounter;
    private GenNavigator myNavigator;
    private GenNavigatorChildReference myNavigatorChildReference;

    protected void setUp() throws Exception {
        super.setUp();
        this.initGenModel();
        this.myClassCounter = 0;
        this.myDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GMFGenFactory.eINSTANCE.createGenEditorGenerator().setDiagram(this.myDiagram);
        this.myNavigator = GMFGenFactory.eINSTANCE.createGenNavigator();
        this.myDiagram.getEditorGen().setNavigator(this.myNavigator);
        this.myNavigatorChildReference = GMFGenFactory.eINSTANCE.createGenNavigatorChildReference();
        this.myNavigator.getChildReferences().add((Object)this.myNavigatorChildReference);
        this.myStartNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.myStartNodeLabel = GMFGenFactory.eINSTANCE.createGenNodeLabel();
        this.myStartNode.getLabels().add((Object)this.myStartNodeLabel);
        this.myStartNodeCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        this.myStartNode.getCompartments().add((Object)this.myStartNodeCompartment);
        this.initializeMF((GenNode)this.myStartNode);
        this.myDiagram.getTopLevelNodes().add((Object)this.myStartNode);
    }

    private void initGenModel() {
        this.myDomainModelPackage = EcoreFactory.eINSTANCE.createEPackage();
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        this.myDomainModelGenPackage = GenModelFactory.eINSTANCE.createGenPackage();
        genModel.getGenPackages().add((Object)this.myDomainModelGenPackage);
        this.myDomainModelGenPackage.setEcorePackage(this.myDomainModelPackage);
    }

    private void initializeMF(GenNode node) {
        TypeModelFacet nodeMF = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        node.setModelFacet(nodeMF);
        nodeMF.setMetaClass(this.createGenClass());
    }

    private GenClass createGenClass() {
        GenClass genClass = GenModelFactory.eINSTANCE.createGenClass();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(this.getUniqueEClassName());
        this.myDomainModelPackage.getEClassifiers().add((Object)eClass);
        genClass.setEcoreClass(eClass);
        this.myDomainModelGenPackage.getGenClasses().add((Object)genClass);
        return genClass;
    }

    private String getUniqueEClassName() {
        return ECLASS_NAME_PREFIX + this.myClassCounter++;
    }

    public void testEmptyPaths() {
        GenChildNode notConnectedNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.myDiagram.getChildNodes().add((Object)notConnectedNode);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.CHILDREN_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)notConnectedNode);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.IN_SOURCE_LITERAL);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
    }

    public void testDirectChildPaths() {
        GenChildNode directChildNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.myStartNode.getChildNodes().add((Object)directChildNode);
        this.myDiagram.getChildNodes().add((Object)directChildNode);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.CHILDREN_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)directChildNode);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, directChildNode});
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNodeLabel);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, this.myStartNodeLabel});
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNodeCompartment);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, this.myStartNodeCompartment});
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myDiagram);
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNode);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myDiagram, this.myStartNode});
        GenLink link = GMFGenFactory.eINSTANCE.createGenLink();
        GenLinkLabel linkLabel = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        link.getLabels().add((Object)linkLabel);
        this.myDiagram.getLinks().add((Object)link);
        this.myNavigatorChildReference.setChild((GenCommonBase)link);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myDiagram, link});
        this.myNavigatorChildReference.setParent((GenCommonBase)link);
        this.myNavigatorChildReference.setChild((GenCommonBase)linkLabel);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{link, linkLabel});
    }

    public void testDirectLinkPaths() {
        GenNode node = this.createGenNode();
        GenLink link = this.createGenLink((GenNode)this.myStartNode, node);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)link);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, link});
        this.myNavigatorChildReference.setParent((GenCommonBase)link);
        this.myNavigatorChildReference.setChild((GenCommonBase)node);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{link, node});
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.IN_SOURCE_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)node);
        this.myNavigatorChildReference.setChild((GenCommonBase)link);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{node, link});
        this.myNavigatorChildReference.setParent((GenCommonBase)link);
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNode);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{link, this.myStartNode});
    }

    private GenNode createGenNode() {
        GenChildNode node = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.myDiagram.getChildNodes().add((Object)node);
        this.initializeMF((GenNode)node);
        return node;
    }

    private GenLink createGenLink(GenNode source, GenNode target) {
        GenLink link = GMFGenFactory.eINSTANCE.createGenLink();
        this.myDiagram.getLinks().add((Object)link);
        TypeLinkModelFacet linkMF = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        link.setModelFacet((LinkModelFacet)linkMF);
        linkMF.setMetaClass(this.createGenClass());
        linkMF.setContainmentMetaFeature(this.createGenFeature(source.getDomainMetaClass(), linkMF.getMetaClass(), true));
        linkMF.setTargetMetaFeature(this.createGenFeature(linkMF.getMetaClass(), target.getDomainMetaClass(), false));
        return link;
    }

    private GenFeature createGenFeature(GenClass sourceGenClass, GenClass targetGenClass, boolean isContainment) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setContainment(isContainment);
        sourceGenClass.getEcoreClass().getEStructuralFeatures().add((Object)eReference);
        eReference.setEType((EClassifier)targetGenClass.getEcoreClass());
        GenFeature genFeature = GenModelFactory.eINSTANCE.createGenFeature();
        genFeature.setEcoreFeature((EStructuralFeature)eReference);
        sourceGenClass.getGenFeatures().add((Object)genFeature);
        return genFeature;
    }

    public void testIndirectChildPaths() {
        GenChildNode indirectChildNode = this.createIndirectChildNode();
        GenCompartment indirectChildNodeCompartment = this.createIndirectChildNodeCompartment(indirectChildNode);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.CHILDREN_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)indirectChildNode);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, this.myStartNodeCompartment, indirectChildNode});
        this.myNavigatorChildReference.setParent((GenCommonBase)indirectChildNode);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{indirectChildNode, indirectChildNodeCompartment, indirectChildNode});
    }

    public void testIndirectLinkPaths() {
        GenNode node1 = this.createGenNode();
        GenLink link1 = this.createGenLink((GenNode)this.myStartNode, node1);
        GenLink link2 = this.createGenLink(node1, node1);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)node1);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, link1, node1});
        this.myNavigatorChildReference.setParent((GenCommonBase)link1);
        this.myNavigatorChildReference.setChild((GenCommonBase)link2);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
        this.myNavigatorChildReference.setParent((GenCommonBase)node1);
        this.myNavigatorChildReference.setChild((GenCommonBase)node1);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{node1, link2, node1});
        this.myNavigatorChildReference.setParent((GenCommonBase)link2);
        this.myNavigatorChildReference.setChild((GenCommonBase)link2);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.IN_SOURCE_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)node1);
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNode);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{node1, link1, this.myStartNode});
        this.myNavigatorChildReference.setParent((GenCommonBase)link2);
        this.myNavigatorChildReference.setChild((GenCommonBase)link1);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
        this.myNavigatorChildReference.setParent((GenCommonBase)node1);
        this.myNavigatorChildReference.setChild((GenCommonBase)node1);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{node1, link2, node1});
        this.myNavigatorChildReference.setParent((GenCommonBase)link2);
        this.myNavigatorChildReference.setChild((GenCommonBase)link2);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenModelGraphAnalyzerTest.assertEquals((String)"No paths should be found", (int)0, (int)paths.size());
    }

    private GenCompartment createIndirectChildNodeCompartment(GenChildNode indirectChildNode) {
        GenCompartment indirectChildNodeCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        indirectChildNode.getCompartments().add((Object)indirectChildNodeCompartment);
        indirectChildNodeCompartment.getChildNodes().add((Object)indirectChildNode);
        return indirectChildNodeCompartment;
    }

    private GenChildNode createIndirectChildNode() {
        GenChildNode indirectChildNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.myStartNodeCompartment.getChildNodes().add((Object)indirectChildNode);
        this.myDiagram.getChildNodes().add((Object)indirectChildNode);
        return indirectChildNode;
    }

    public void testSeveralChildPaths() {
        GenChildNode indirectChildNode = this.createIndirectChildNode();
        GenCompartment indirectChildNodeCompartment = this.createIndirectChildNodeCompartment(indirectChildNode);
        GenChildNode doublePathChildNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.myDiagram.getChildNodes().add((Object)doublePathChildNode);
        this.myStartNodeCompartment.getChildNodes().add((Object)doublePathChildNode);
        indirectChildNodeCompartment.getChildNodes().add((Object)doublePathChildNode);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.CHILDREN_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)doublePathChildNode);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        GenCommonBase[] truePath1 = new GenCommonBase[]{this.myStartNode, this.myStartNodeCompartment, doublePathChildNode};
        GenCommonBase[] truePath2 = new GenCommonBase[]{this.myStartNode, this.myStartNodeCompartment, indirectChildNode, indirectChildNodeCompartment, doublePathChildNode};
        this.assertTwoPaths(paths, truePath1, truePath2);
    }

    public void testOneLinkPathsUsed() {
        GenNode node1 = this.createGenNode();
        GenNode node2 = this.createGenNode();
        node1.getDomainMetaClass().getEcoreClass().getESuperTypes().add((Object)node2.getDomainMetaClass().getEcoreClass());
        GenLink link1 = this.createGenLink((GenNode)this.myStartNode, node2);
        this.createGenLink(node2, node1);
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)this.myStartNode);
        this.myNavigatorChildReference.setChild((GenCommonBase)node1);
        List paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{this.myStartNode, link1, node1});
        this.myNavigatorChildReference.setReferenceType(GenNavigatorReferenceType.IN_SOURCE_LITERAL);
        this.myNavigatorChildReference.setParent((GenCommonBase)node1);
        this.myNavigatorChildReference.setChild((GenCommonBase)this.myStartNode);
        paths = GenModelGraphAnalyzer.getConnectionPaths((GenNavigatorChildReference)this.myNavigatorChildReference);
        this.assertOnePath(paths, new GenCommonBase[]{node1, link1, this.myStartNode});
    }

    private void assertOnePath(List<List<GenCommonBase>> paths, GenCommonBase[] truePath) {
        GenModelGraphAnalyzerTest.assertEquals((String)"Only one path should be found", (int)1, (int)paths.size());
        List<GenCommonBase> path = paths.get(0);
        GenModelGraphAnalyzerTest.assertEquals((String)"Incorrect size path found", (int)truePath.length, (int)path.size());
        this.assertPath(path, truePath);
    }

    private void assertTwoPaths(List<List<GenCommonBase>> paths, GenCommonBase[] truePath1, GenCommonBase[] truePath2) {
        GenModelGraphAnalyzerTest.assertEquals((String)"Incorrect number of paths returned", (int)2, (int)paths.size());
        List<GenCommonBase> path1 = paths.get(0);
        List<GenCommonBase> path2 = paths.get(1);
        if (path1.size() == truePath1.length) {
            this.assertPath(path1, truePath1);
            this.assertPath(path2, truePath2);
        } else {
            this.assertPath(path1, truePath2);
            this.assertPath(path2, truePath1);
        }
    }

    private void assertPath(List<GenCommonBase> path, GenCommonBase[] truePath) {
        int i = 0;
        while (i < path.size()) {
            GenModelGraphAnalyzerTest.assertEquals((String)("Path contains incorrect element N " + i), (Object)truePath[i], (Object)path.get(i));
            ++i;
        }
    }
}

