/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.adwp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.m2m.atl.engine.vm.adwp.BooleanValue;
import org.eclipse.m2m.atl.engine.vm.adwp.IntegerValue;
import org.eclipse.m2m.atl.engine.vm.adwp.NullValue;
import org.eclipse.m2m.atl.engine.vm.adwp.ObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.RealValue;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;

public abstract class ADWP
extends Thread {
    public static final int CMD_CONTINUE = 0;
    public static final int CMD_STEP = 1;
    public static final int CMD_STEP_OVER = 2;
    public static final int CMD_FINISH = 3;
    public static final int CMD_GET = 10;
    public static final int CMD_SET = 11;
    public static final int CMD_CALL = 12;
    public static final int CMD_SET_BP = 13;
    public static final int CMD_UNSET_BP = 14;
    public static final int CMD_DISASSEMBLE = 20;
    public static final int CMD_QUERY = 21;
    public static final int MSG_STOPPED = 100;
    public static final int MSG_ANS = 101;
    public static final int MSG_DISAS_CODE = 102;
    public static final int MSG_TERMINATED = 103;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_OBJECT = 4;
    public static final int TYPE_NULL = 5;
    public static final int TYPE_REAL = 6;
    protected DataInputStream in;
    protected DataOutputStream out;

    public ADWP(InputStream in, OutputStream out) {
        this.in = new DataInputStream(new BufferedInputStream(in));
        this.out = new DataOutputStream(new BufferedOutputStream(out));
        this.start();
    }

    protected void writeValue(Value value) throws IOException {
        if (value instanceof StringValue) {
            String v = ((StringValue)value).getValue();
            this.out.writeByte(3);
            this.out.writeUTF(v);
        } else if (value instanceof IntegerValue) {
            int v = ((IntegerValue)value).getValue();
            this.out.writeByte(2);
            this.out.writeInt(v);
        } else if (value instanceof RealValue) {
            double v = ((RealValue)value).getValue();
            this.out.writeByte(6);
            this.out.writeDouble(v);
        } else if (value instanceof BooleanValue) {
            boolean v = ((BooleanValue)value).getValue();
            this.out.writeByte(1);
            this.out.writeBoolean(v);
        } else if (value instanceof ObjectReference) {
            int id = ((ObjectReference)value).getId();
            this.out.writeByte(4);
            this.out.writeInt(id);
        } else if (value instanceof NullValue || value == null) {
            this.out.writeByte(5);
        }
    }

    protected Value readValue() throws IOException {
        Value ret = null;
        int type = this.in.readByte() & 0xFF;
        switch (type) {
            case 3: {
                ret = StringValue.valueOf(this.in.readUTF());
                break;
            }
            case 2: {
                ret = IntegerValue.valueOf(this.in.readInt());
                break;
            }
            case 6: {
                ret = RealValue.valueOf(this.in.readDouble());
                break;
            }
            case 1: {
                ret = BooleanValue.valueOf(this.in.readBoolean());
                break;
            }
            case 4: {
                ret = this.readObjectReference(this.in.readInt());
                break;
            }
            case 5: {
                ret = new NullValue();
            }
        }
        return ret;
    }

    protected abstract ObjectReference readObjectReference(int var1);
}

