/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.common;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class EfficientLazyString
implements CharSequence {
    private boolean _isDirty = false;
    private boolean _isImmutable = false;
    private String _asString = "";
    private final List<Object> _contents = new ArrayList<Object>();
    private EfficientLazyString _parent = null;

    public static EfficientLazyString createAppendedString(EfficientLazyString s, Object o) {
        if (s._isImmutable) {
            EfficientLazyString result = new EfficientLazyString();
            result.append(s);
            result.append(o);
            return result;
        }
        s.append(o);
        return s;
    }

    private void append(Object o) {
        if (o != null) {
            this.setDirty();
            this._contents.add(o);
            if (o instanceof EfficientLazyString) {
                ((EfficientLazyString)o)._parent = this;
            }
        }
    }

    public void makeImmutable() {
        this._isImmutable = true;
    }

    private void setDirty() {
        this._isDirty = true;
        if (this._parent != null) {
            this._parent.setDirty();
        }
    }

    public void writeTo(Writer w) throws IOException {
        if (this._isDirty) {
            for (Object o : this._contents) {
                if (o instanceof EfficientLazyString) {
                    ((EfficientLazyString)o).writeTo(w);
                    continue;
                }
                w.write(o.toString());
            }
        } else {
            w.write(this._asString);
        }
    }

    public String toString() {
        if (this._isDirty) {
            StringBuilder result = new StringBuilder(32768);
            for (Object o : this._contents) {
                result.append(o);
            }
            this._asString = result.toString();
        }
        return this._asString;
    }

    public boolean equals(Object obj) {
        throw new IllegalArgumentException("EfficientLazyString can not be compared directly - compare string representations");
    }

    public int hashCode() {
        throw new IllegalArgumentException("EfficientLazyString can not be compared directly - compare string representations");
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public int length() {
        return this.toString().length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }
}

