/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.emf;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.builtin.VoidType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;

public final class EObjectType
extends AbstractType {
    public static final EObjectType INSTANCE = new EObjectType();

    private EObjectType() {
        super("emf::EObject", EmfTypesystem.getUniqueIdentifier((EClassifier)EcorePackage.eINSTANCE.getEObject()), new BackendType[0]);
        this.register(new AbstractProperty(this, EObject.class, "eContainer", true, false){

            public Object getRaw(ExecutionContext ctx, Object o) {
                return ((EObject)o).eContainer();
            }

            public BackendType getType(BackendTypesystem ts) {
                return INSTANCE;
            }
        }, this);
        this.register(new AbstractProperty(this, List.class, "eContents", true, false){

            public Object getRaw(ExecutionContext ctx, Object o) {
                return ((EObject)o).eContents();
            }

            public BackendType getType(BackendTypesystem ts) {
                return CollectionType.INSTANCE;
            }
        }, CollectionType.INSTANCE);
        this.register(new AbstractProperty(this, EObject.class, "eRootContainer", true, false){

            public Object getRaw(ExecutionContext ctx, Object o) {
                return EcoreUtil.getRootContainer((EObject)((EObject)o));
            }

            public BackendType getType(BackendTypesystem ts) {
                return INSTANCE;
            }
        }, this);
        this.register(new AbstractProperty(this, Set.class, "eAllContents", true, false){

            public Object getRaw(ExecutionContext ctx, Object o) {
                HashSet result = new HashSet();
                TreeIterator iter = ((EObject)o).eAllContents();
                while (iter.hasNext()) {
                    result.add(iter.next());
                }
                return result;
            }

            public BackendType getType(BackendTypesystem ts) {
                return CollectionType.INSTANCE;
            }
        }, CollectionType.INSTANCE);
    }

    public boolean isAssignableFrom(BackendType other) {
        return other == this || other == VoidType.INSTANCE;
    }

    public boolean equals(Object other) {
        return other == this;
    }
}

