/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.shared.ui.wizards.EclipseHelper;
import org.eclipse.xtend.shared.ui.wizards.XtendXpandProjectWizardPage;

public class XtendXpandProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private XtendXpandProjectWizardPage page;
    private IConfigurationElement configElement;

    public XtendXpandProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new XtendXpandProjectWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String name = this.page.getProjectName();
        final boolean genExample = this.page.isCreateExample();
        final boolean projectSpecific = this.page.isProjectSpecificMM();
        final boolean workspaceDefault = this.page.isUseWorkspaceDefinedMM();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    XtendXpandProjectWizard.this.doFinish(name, genExample, projectSpecific, workspaceDefault, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.XtendXpandProjectWizard_ErrorLabel, (String)realException.getMessage());
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    void doFinish(String name, boolean genExamle, boolean projectSpecific, boolean workspaceDefaults, IProgressMonitor monitor) {
        String projectName = name;
        int ticks = genExamle ? 15 : 6;
        monitor.beginTask(String.valueOf(Messages.XtendXpandProjectWizard_ProjectCreationMessage) + name, ticks);
        HashSet<String> refs = new HashSet<String>();
        ArrayList<String> srcfolders = new ArrayList<String>();
        srcfolders.add("src");
        srcfolders.add("src-gen");
        refs.add("org.eclipse.jdt.core;bundle-version=\"3.5.0\"");
        refs.add("org.apache.commons.logging");
        refs.add("org.apache.log4j;resolution:=optional");
        refs.add("org.eclipse.xtend.profiler;resolution:=optional");
        IProject p = EclipseHelper.createExtXptProject(projectName, srcfolders, Collections.<IProject>emptyList(), refs, null, (IProgressMonitor)new SubProgressMonitor(monitor, 3), this.getShell());
        if (p == null) {
            return;
        }
        String encoding = ResourcesPlugin.getEncoding();
        EclipseHelper.createFile(".settings/org.eclipse.core.resources.prefs", (IContainer)p, "eclipse.preferences.version=1\nencoding/<project>=" + encoding + "\n", (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        if (genExamle) {
            EclipseHelper.createFile(".settings/org.eclipse.xtend.shared.ui.prefs", (IContainer)p, "metamodelContributor=org.eclipse.xtend.typesystem.emf.ui.EmfMetamodelContributor\nproject.specific.metamodel=true\n", (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/metamodel/Checks.chk", (IContainer)p, this.getContents("Checks.chk"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/metamodel/Extensions.ext", (IContainer)p, this.getContents("Extensions.ext"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/metamodel/metamodel.ecore", (IContainer)p, this.getContents("metamodel.ecore"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/template/GeneratorExtensions.ext", (IContainer)p, this.getContents("GeneratorExtensions.ext"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/template/Template.xpt", (IContainer)p, this.getContents("Template.xpt"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/workflow/generator.mwe", (IContainer)p, this.getContents("generator.mwe").replace("PROJECTNAME", projectName), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/workflow/generatorWithBackend.mwe", (IContainer)p, this.getContents("generatorWithBackend.mwe").replace("PROJECTNAME", projectName), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/workflow/generatorWithProfiler.mwe", (IContainer)p, this.getContents("generatorWithProfiler.mwe").replace("PROJECTNAME", projectName), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            EclipseHelper.createFile("src/Model.xmi", (IContainer)p, this.getContents("Model.xmi"), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
        } else if (projectSpecific) {
            EclipseHelper.createFile(".settings/org.eclipse.xtend.shared.ui.prefs", (IContainer)p, "eclipse.preferences.version=1\nproject.specific.metamodel=true\nmetamodelContributor=" + this.page.getStoreString(), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
        }
        monitor.worked(1);
    }

    private String getContents(String resource) {
        try {
            int read;
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/eclipse/xtend/shared/ui/wizards/example/" + resource);
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.close();
            inputStream.close();
            return outputStream.toString("iso-8859-1");
        }
        catch (IOException e) {
            XtendLog.logError(e);
            return "";
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

