/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandSourceViewerConfiguration;
import org.eclipse.xtend.shared.ui.editor.BreakpointActionGroup;
import org.eclipse.xtend.shared.ui.editor.navigation.OpenAction;
import org.eclipse.xtend.shared.ui.editor.outlineview.AbstractExtXptContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.search.actions.SearchActionGroup;

public abstract class AbstractXtendXpandEditor
extends TextEditor {
    private AbstractExtXptContentOutlinePage outlinePage = null;
    private SearchActionGroup searchActionGroup;
    private BreakpointActionGroup bpActionGroup;
    private ISelectionChangedListener selectionChangedListener;
    private IPropertyChangeListener preferencesChangedListener;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractXtendXpandEditor.this.updateStatusLine();
            }
        };
        this.installSelectionChangedListener();
        this.preferencesChangedListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("xpd_")) {
                    AbstractXtendXpandSourceViewerConfiguration config = (AbstractXtendXpandSourceViewerConfiguration)AbstractXtendXpandEditor.this.getSourceViewerConfiguration();
                    config.refresh();
                    AbstractXtendXpandEditor.this.getSourceViewer().invalidateTextPresentation();
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesChangedListener);
    }

    private void installSelectionChangedListener() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
            postSelectionProvider.addPostSelectionChangedListener(this.selectionChangedListener);
        } else {
            this.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.uninstallSelectionChangedListener();
        if (this.preferencesChangedListener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesChangedListener);
        }
    }

    private void uninstallSelectionChangedListener() {
        ISelectionProvider selectionProvider;
        if (this.selectionChangedListener != null && (selectionProvider = this.getSelectionProvider()) != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
                postSelectionProvider.removePostSelectionChangedListener(this.selectionChangedListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
        }
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public void doSave(IProgressMonitor aMonitor) {
        super.doSave(aMonitor);
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("Xpand"));
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.searchActionGroup.setContext(context);
        this.searchActionGroup.fillContextMenu(menu);
        this.searchActionGroup.setContext(null);
        this.bpActionGroup.fillContextMenu(menu);
    }

    public Object getAdapter(Class aRequired) {
        if (IContentOutlinePage.class.equals((Object)aRequired)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput(this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(aRequired);
    }

    protected abstract AbstractExtXptContentOutlinePage createOutlinePage();

    protected void createActions() {
        super.createActions();
        ResourceBundle rb = new ResourceBundle(){

            public Enumeration getKeys() {
                return new Vector().elements();
            }

            protected Object handleGetObject(String key) {
                return null;
            }
        };
        TextOperationAction a = new TextOperationAction(rb, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(rb, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        OpenAction openAction = new OpenAction(this);
        openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.setAction("org.eclipse.jdt.ui.actions.Open", (IAction)openAction);
        this.searchActionGroup = new SearchActionGroup(this);
        this.bpActionGroup = new BreakpointActionGroup(this);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("Xpand"));
        super.rulerContextMenuAboutToShow(menu);
        this.bpActionGroup.fillContextMenu(menu);
    }

    public ISourceViewer internalGetSourceViewer() {
        return this.getSourceViewer();
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        String message = null;
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (this.isProblemMarkerAnnotation(annotation)) {
                message = annotation.getText();
            }
        }
        this.setStatusLineMessage(message);
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator iterator = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation a = (Annotation)iterator.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    private boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            return false;
        }
    }
}

