/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeType
extends AbstractTypeImpl {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    Stereotype stereoType;
    private Set<Type> superTypes = null;

    public StereotypeType(TypeSystem typeSystem, String name, Stereotype stereoType) {
        super(typeSystem, name);
        this.stereoType = stereoType;
    }

    public Feature[] getContributedFeatures() {
        EList children = this.stereoType.getAttributes();
        ArrayList<1> features = new ArrayList<1>();
        for (Object obj : children) {
            String fqn;
            Property p;
            String name;
            if (!(obj instanceof Property) || (name = StereotypeType.normalizedName((p = (Property)obj).getName())) == null) continue;
            org.eclipse.uml2.uml.Type type = p.getType();
            if (type.eIsProxy()) {
                InternalEObject proxy = (InternalEObject)type;
                URI uri = proxy.eProxyURI();
                type = (org.eclipse.uml2.uml.Type)EcoreUtil.resolve((EObject)proxy, (EObject)p);
                if (type.eIsProxy()) {
                    this.log.error((Object)("Couldn't resolve proxy under " + uri));
                }
            }
            if ((fqn = this.getFullName(type)) == null) {
                this.log.error((Object)("element : " + p.getQualifiedName()));
                this.log.error((Object)("Type : " + type.getQualifiedName()));
            }
            if (fqn == null) continue;
            Type rt = null;
            rt = fqn.toLowerCase().endsWith("::string") ? this.getTypeSystem().getStringType() : (fqn.toLowerCase().endsWith("::boolean") ? this.getTypeSystem().getBooleanType() : (fqn.toLowerCase().endsWith("::integer") || fqn.toLowerCase().endsWith("::int") ? this.getTypeSystem().getIntegerType() : (fqn.toLowerCase().endsWith("::real") ? this.getTypeSystem().getRealType() : this.getTypeSystem().getTypeForName(fqn))));
            if (p.isMultivalued()) {
                rt = this.getTypeSystem().getCollectionType(rt);
            }
            if (rt != null) {
                PropertyImpl prop = new PropertyImpl((Type)this, name, rt){

                    public Object get(Object target) {
                        if (target instanceof Element) {
                            Element ele = (Element)target;
                            EList all = ele.getAppliedStereotypes();
                            for (Stereotype st : all) {
                                Object dynValue;
                                if (!StereotypeType.this.isStereoTypeAssignable(st, StereotypeType.this.stereoType)) continue;
                                Object value = ele.getValue(st, this.getName());
                                if (value instanceof EList) {
                                    EList eList = (EList)value;
                                    ArrayList<Object> values = new ArrayList<Object>();
                                    for (Object dynObject : eList) {
                                        Object dynValue2 = this.getDynamicValue(dynObject);
                                        if (dynValue2 == null) continue;
                                        values.add(dynValue2);
                                    }
                                    if (!values.isEmpty()) {
                                        return values;
                                    }
                                } else if (value instanceof EObject && (dynValue = this.getDynamicValue(value)) != null) {
                                    return dynValue;
                                }
                                return value;
                            }
                        }
                        throw new IllegalArgumentException("uml2 Element expected but was " + target.getClass().getName());
                    }

                    private Object getDynamicValue(Object value) {
                        if (value instanceof EObject) {
                            EObject dynObject = (EObject)value;
                            EClass dynClass = dynObject.eClass();
                            EList eStructuralFeatures = dynClass.getEAllStructuralFeatures();
                            for (EStructuralFeature feature : eStructuralFeatures) {
                                if (!feature.getName().startsWith("base_")) continue;
                                return dynObject.eGet(feature, true);
                            }
                        }
                        return null;
                    }
                };
                features.add(prop);
                continue;
            }
            this.log.error((Object)("Couldn't find type for " + fqn));
        }
        return features.toArray(new Feature[features.size()]);
    }

    private boolean isStereoTypeAssignable(Stereotype st1, Stereotype st2) {
        if (st1.getQualifiedName().equals(st2.getQualifiedName())) {
            return true;
        }
        EList gs = st1.getGeneralizations();
        for (Generalization g : gs) {
            if (!(g.getGeneral() instanceof Stereotype) || !this.isStereoTypeAssignable((Stereotype)g.getGeneral(), st2)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstance(Object o) {
        if (o instanceof Element) {
            Element ele = (Element)o;
            EList all = ele.getAppliedStereotypes();
            for (Stereotype st : all) {
                if (!this.isStereoTypeAssignable(st, this.stereoType)) continue;
                return true;
            }
        }
        return false;
    }

    public Object newInstance() {
        throw new UnsupportedOperationException();
    }

    public Set<Type> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = new HashSet<Type>();
            ArrayList all = new ArrayList(this.stereoType.getExtendedMetaclasses());
            all.addAll(this.stereoType.getSuperClasses());
            for (Classifier classifier : all) {
                String superTypeName = this.getFullName(classifier);
                Type t = this.getTypeSystem().getTypeForName(superTypeName);
                if (t == null) {
                    this.log.warn((Object)("Couldn't resolve super type " + superTypeName));
                    continue;
                }
                this.superTypes.add(t);
            }
        }
        return Collections.unmodifiableSet(this.superTypes);
    }

    public Stereotype getStereoType() {
        return this.stereoType;
    }

    private String getFullName(Object object) {
        if (object instanceof NamedElement) {
            return StereotypeType.normalizedName(((NamedElement)object).getQualifiedName());
        }
        if (object instanceof EClassifier) {
            return this.getFullyQualifiedName((ENamedElement)((EClassifier)object));
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Cannot resolve names for " + object.getClass().getName()));
        }
        return null;
    }

    private String getFullyQualifiedName(ENamedElement ele) {
        return this.getFqnRec(ele.eContainer(), ele.getName());
    }

    private String getFqnRec(EObject ele, String suffix) {
        if (ele == null || !(ele instanceof ENamedElement)) {
            return suffix;
        }
        return this.getFqnRec(ele.eContainer(), String.valueOf(((ENamedElement)ele).getName()) + "::" + suffix);
    }

    protected boolean internalIsAssignableFrom(Type t) {
        if (super.internalIsAssignableFrom(t)) {
            return true;
        }
        if (t instanceof StereotypeType) {
            return ((StereotypeType)t).isCompatible((Type)this);
        }
        return false;
    }

    protected boolean isCompatible(Type t) {
        return false;
    }

    private static String normalizedName(String name) {
        String[] fragments = name.split("::");
        StringBuffer result = new StringBuffer(name.length());
        result.append(fragments[0].replaceAll("\\W", "_"));
        int i = 1;
        while (i < fragments.length) {
            result.append("::");
            result.append(fragments[1].replaceAll("\\W", "_"));
            ++i;
        }
        return result.toString();
    }
}

